/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.gpsmock;

import android.location.Location;
import com.amap.api.location.AMapLocation;
import com.amap.api.navi.model.AMapNaviLocation;
import com.amap.api.navi.model.NaviLatLng;
import com.baidu.location.BDLocation;
import com.didichuxing.doraemonkit.kit.gpsmock.CordTransformUtil;
import com.didichuxing.doraemonkit.kit.gpsmock.TencentLocationImp;

public class LocationBuilder {
    private double mLatitude = -1.0;
    private double mLongitude = -1.0;
    private float mSpeed = 0.0f;
    private float mBearing = 0.0f;
    private long mTime = 0L;
    private float mHorizontalAccuracyMeters = 0.0f;

    public static AMapLocation toAMapLocation(Location location) {
        AMapLocation aMapLocation = new AMapLocation(location);
        aMapLocation.setSpeed(location.getSpeed());
        aMapLocation.setBearing(location.getBearing());
        aMapLocation.setAccuracy(location.getAccuracy());
        aMapLocation.setTime(location.getTime());
        return aMapLocation;
    }

    public static AMapNaviLocation toAMapNaviLocation(Location location) {
        AMapNaviLocation aMapNaviLocation = new AMapNaviLocation();
        aMapNaviLocation.setSpeed(location.getSpeed());
        aMapNaviLocation.setBearing(location.getBearing());
        aMapNaviLocation.setAccuracy(location.getAccuracy());
        aMapNaviLocation.setTime(location.getTime());
        aMapNaviLocation.setCoord(new NaviLatLng(location.getLatitude(), location.getLongitude()));
        return aMapNaviLocation;
    }

    public static TencentLocationImp toTencentLocation(Location location) {
        if (location == null) {
            return null;
        }
        TencentLocationImp tencentLocation = new TencentLocationImp();
        tencentLocation.setLatitude(location.getLatitude()).setLongitude(location.getLongitude()).setSpeed(location.getSpeed()).setBearing(location.getBearing()).setAccuracy(location.getAccuracy()).setTime(location.getTime());
        return tencentLocation;
    }

    public static BDLocation toBdLocation(Location location) {
        if (location == null) {
            return null;
        }
        BDLocation bdLocation = new BDLocation();
        CordTransformUtil.Point point = CordTransformUtil.wgs84tobd09(location.getLatitude(), location.getLongitude());
        bdLocation.setLatitude(point.getLatitude());
        bdLocation.setLongitude(point.getLongitude());
        bdLocation.setSpeed(location.getSpeed());
        bdLocation.setDirection(location.getBearing());
        bdLocation.setRadius(location.getAccuracy());
        return bdLocation;
    }

    public LocationBuilder fromLocation(Location location) {
        this.mLatitude = location.getLatitude();
        this.mLongitude = location.getLongitude();
        this.mSpeed = location.getSpeed();
        this.mBearing = location.getBearing();
        this.mTime = location.getTime();
        this.mHorizontalAccuracyMeters = location.getAccuracy();
        return this;
    }

    public LocationBuilder setLatitude(double latitude) {
        this.mLatitude = latitude;
        return this;
    }

    public LocationBuilder setLongitude(double longitude) {
        this.mLongitude = longitude;
        return this;
    }

    public LocationBuilder setSpeed(float speed) {
        this.mSpeed = speed;
        return this;
    }

    public LocationBuilder setBearing(float bearing) {
        this.mBearing = bearing;
        return this;
    }

    public LocationBuilder setTime(long time) {
        this.mTime = time;
        return this;
    }

    public LocationBuilder setHorizontalAccuracyMeters(float horizontalAccuracyMeters) {
        this.mHorizontalAccuracyMeters = horizontalAccuracyMeters;
        return this;
    }

    public Location build() {
        Location dokit_mock_gps = new Location("DOKIT_MOCK");
        dokit_mock_gps.setLatitude(this.mLatitude);
        dokit_mock_gps.setLongitude(this.mLongitude);
        dokit_mock_gps.setSpeed(this.mSpeed);
        dokit_mock_gps.setBearing(this.mBearing);
        dokit_mock_gps.setTime(this.mTime);
        dokit_mock_gps.setAccuracy(this.mHorizontalAccuracyMeters);
        return dokit_mock_gps;
    }
}

