/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.core;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.BaseActivity;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.main.MainIconDoKitView;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.dialog.CommonDialogProvider;
import com.didichuxing.doraemonkit.widget.dialog.DialogInfo;
import com.didichuxing.doraemonkit.widget.dialog.DialogProvider;
import com.didichuxing.doraemonkit.widget.dialog.UniversalDialogFragment;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bJ\u001f\u0010\t\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0004J\b\u0010\u0012\u001a\u00020\u0011H\u0016J&\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\rH%J\u001a\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J$\u0010\u001d\u001a\u00020\u00062\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0019H\u0007J\u0012\u0010!\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\"\u001a\u00020#J\u0014\u0010!\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010$\u001a\u00020\u00062\b\b\u0001\u0010%\u001a\u00020\rJ\u000e\u0010$\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/didichuxing/doraemonkit/kit/core/BaseFragment;", "Landroidx/fragment/app/Fragment;", "()V", "TAG", "", "dismissDialog", "", "provider", "Lcom/didichuxing/doraemonkit/widget/dialog/DialogProvider;", "findViewById", "T", "Landroid/view/View;", "id", "", "(I)Landroid/view/View;", "finish", "interceptTouchEvents", "", "onBackPressed", "onCreateView", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onRequestLayout", "onViewCreated", "view", "showContent", "fragmentClass", "Ljava/lang/Class;", "bundle", "showDialog", "dialogInfo", "Lcom/didichuxing/doraemonkit/widget/dialog/DialogInfo;", "showToast", "res", "msg", "dokit_release"})
public abstract class BaseFragment
extends Fragment {
    @JvmField
    @NotNull
    public final String TAG;

    @LayoutRes
    protected abstract int onRequestLayout();

    @NotNull
    public final <T extends View> T findViewById(@IdRes int id2) {
        View view = this.requireView().findViewById(id2);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"requireView().findViewById(id)");
        return (T)view;
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        int id2 = this.onRequestLayout();
        View rootView = null;
        if (id2 > 0) {
            rootView = inflater.inflate(id2, container, false);
        }
        if (this.interceptTouchEvents() && rootView != null) {
            rootView.setOnTouchListener((View.OnTouchListener)onCreateView.1.INSTANCE);
        }
        return rootView;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        try {
            if (view.getContext() instanceof Activity) {
                Context context = view.getContext();
                if (context == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.Activity");
                }
                Window window = ((Activity)context).getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"(view.context as Activity).window");
                window.getDecorView().requestLayout();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DoKit.Companion.removeFloating((KClass<? extends AbsDokitView>)Reflection.getOrCreateKotlinClass(MainIconDoKitView.class));
    }

    protected final boolean interceptTouchEvents() {
        return false;
    }

    public boolean onBackPressed() {
        return false;
    }

    @JvmOverloads
    public final void showContent(@NotNull Class<? extends BaseFragment> fragmentClass, @Nullable Bundle bundle) {
        block0: {
            BaseActivity activity;
            Intrinsics.checkNotNullParameter(fragmentClass, (String)"fragmentClass");
            BaseActivity baseActivity = activity = (BaseActivity)this.getActivity();
            if (baseActivity == null) break block0;
            baseActivity.showContent(fragmentClass, bundle);
        }
    }

    public static /* synthetic */ void showContent$default(BaseFragment baseFragment, Class clazz, Bundle bundle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showContent");
        }
        if ((n & 2) != 0) {
            bundle = null;
        }
        baseFragment.showContent(clazz, bundle);
    }

    @JvmOverloads
    public final void showContent(@NotNull Class<? extends BaseFragment> fragmentClass) {
        BaseFragment.showContent$default(this, fragmentClass, null, 2, null);
    }

    public final void finish() {
        block0: {
            BaseActivity activity;
            BaseActivity baseActivity = activity = (BaseActivity)this.getActivity();
            if (baseActivity == null) break block0;
            baseActivity.doBack(this);
        }
    }

    @NotNull
    public final DialogProvider<?> showDialog(@NotNull DialogInfo dialogInfo) {
        Intrinsics.checkNotNullParameter((Object)dialogInfo, (String)"dialogInfo");
        CommonDialogProvider<DialogInfo> provider = new CommonDialogProvider<DialogInfo>(dialogInfo, dialogInfo.listener);
        this.showDialog((DialogProvider)provider);
        return provider;
    }

    public void showDialog(@NotNull DialogProvider<?> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        UniversalDialogFragment dialog = new UniversalDialogFragment();
        provider.setHost(dialog);
        dialog.setProvider(provider);
        provider.show(this.getChildFragmentManager());
    }

    public final void dismissDialog(@NotNull DialogProvider<?> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        provider.dismiss();
    }

    public final void showToast(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        ToastUtils.showShort((String)msg, (Object[])new Object[0]);
    }

    public final void showToast(@StringRes int res) {
        ToastUtils.showShort((int)res);
    }

    public BaseFragment() {
        String string2 = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.javaClass.simpleName");
        this.TAG = string2;
    }
}

