/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.blockmonitor.core;

import android.content.Context;
import android.text.TextUtils;
import com.didichuxing.doraemonkit.kit.blockmonitor.bean.BlockInfo;
import com.didichuxing.doraemonkit.util.DoKitSystemUtil;

public final class BlockCanaryUtils {
    private static String sProcessName;
    private static boolean sProcessNameFirstGetFlag;
    private static final String CURRENT_PACKAGE = "com.didichuxing.doraemonkit";

    public static String concernStackString(Context context, BlockInfo blockInfo) {
        String result2 = "";
        for (String stackEntry : blockInfo.threadStackEntries) {
            String[] lines;
            if (TextUtils.isEmpty((CharSequence)stackEntry)) continue;
            for (String line : lines = stackEntry.split("\r\n")) {
                String keyStackString = BlockCanaryUtils.concernStackString(context, line);
                if (keyStackString == null) continue;
                return keyStackString;
            }
            return BlockCanaryUtils.classSimpleName(lines[0]);
        }
        return result2;
    }

    public static boolean isBlockInfoValid(BlockInfo blockInfo) {
        boolean isValid = !TextUtils.isEmpty((CharSequence)blockInfo.timeStart);
        isValid = isValid && blockInfo.timeCost >= 0L;
        return isValid;
    }

    private static String concernStackString(Context context, String line) {
        if (line == null) {
            return null;
        }
        if (!sProcessNameFirstGetFlag) {
            sProcessNameFirstGetFlag = true;
            sProcessName = DoKitSystemUtil.obtainProcessName(context);
        }
        if (sProcessName == null || line.startsWith(sProcessName) || line.startsWith(CURRENT_PACKAGE)) {
            return BlockCanaryUtils.classSimpleName(line);
        }
        return null;
    }

    private static String classSimpleName(String stackLine) {
        int index1 = stackLine.indexOf(40);
        int index2 = stackLine.indexOf(41);
        if (index1 >= 0 && index2 >= 0) {
            return stackLine.substring(index1 + 1, index2);
        }
        return stackLine;
    }

    static {
        sProcessNameFirstGetFlag = false;
    }
}

