/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.alignruler;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.util.UIUtils;
import java.util.ArrayList;
import java.util.List;

public class AlignRulerMarkerDokitView
extends AbsDokitView {
    private List<OnAlignRulerMarkerPositionChangeListener> mPositionChangeListeners = new ArrayList<OnAlignRulerMarkerPositionChangeListener>();

    @Override
    public View onCreateView(Context context, FrameLayout view) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_float_align_ruler_marker, null);
    }

    @Override
    public void onViewCreated(FrameLayout view) {
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.height = DokitViewLayoutParams.WRAP_CONTENT;
        params.width = DokitViewLayoutParams.WRAP_CONTENT;
        params.x = UIUtils.getWidthPixels() / 2;
        params.y = UIUtils.getHeightPixels() / 2;
    }

    @Override
    public void onCreate(Context context) {
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.removePositionChangeListeners();
    }

    @Override
    public void onMove(int x, int y, int dx, int dy) {
        super.onMove(x, y, dx, dy);
        for (OnAlignRulerMarkerPositionChangeListener listener : this.mPositionChangeListeners) {
            if (this.isNormalMode()) {
                listener.onPositionChanged(this.getNormalLayoutParams().leftMargin + this.getDoKitView().getWidth() / 2, this.getNormalLayoutParams().topMargin + this.getDoKitView().getHeight() / 2);
                continue;
            }
            listener.onPositionChanged(this.getSystemLayoutParams().x + this.getDoKitView().getWidth() / 2, this.getSystemLayoutParams().y + this.getDoKitView().getHeight() / 2);
        }
    }

    @Override
    public void updateViewLayout(String tag, boolean isActivityBackResume) {
        super.updateViewLayout(tag, isActivityBackResume);
        for (OnAlignRulerMarkerPositionChangeListener listener : this.mPositionChangeListeners) {
            if (this.isNormalMode()) {
                listener.onPositionChanged(this.getNormalLayoutParams().leftMargin + this.getDoKitView().getWidth() / 2, this.getNormalLayoutParams().topMargin + this.getDoKitView().getHeight() / 2);
                continue;
            }
            listener.onPositionChanged(this.getSystemLayoutParams().x + this.getDoKitView().getWidth() / 2, this.getSystemLayoutParams().y + this.getDoKitView().getHeight() / 2);
        }
    }

    public void addPositionChangeListener(OnAlignRulerMarkerPositionChangeListener positionChangeListener) {
        this.mPositionChangeListeners.add(positionChangeListener);
        for (OnAlignRulerMarkerPositionChangeListener listener : this.mPositionChangeListeners) {
            if (this.isNormalMode()) {
                listener.onPositionChanged(this.getNormalLayoutParams().leftMargin + this.getDoKitView().getWidth() / 2, this.getNormalLayoutParams().topMargin + this.getDoKitView().getHeight() / 2);
                continue;
            }
            listener.onPositionChanged(this.getSystemLayoutParams().x + this.getDoKitView().getWidth() / 2, this.getSystemLayoutParams().y + this.getDoKitView().getHeight() / 2);
        }
    }

    public void removePositionChangeListener(OnAlignRulerMarkerPositionChangeListener positionChangeListener) {
        this.mPositionChangeListeners.remove(positionChangeListener);
    }

    private void removePositionChangeListeners() {
        this.mPositionChangeListeners.clear();
    }

    @Override
    public boolean restrictBorderline() {
        return false;
    }

    public static interface OnAlignRulerMarkerPositionChangeListener {
        public void onPositionChanged(int var1, int var2);
    }
}

