/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.aop.bigimg.fresco;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.config.PerformanceSpInfoConfig;
import com.didichuxing.doraemonkit.kit.largepicture.LargePictureManager;
import com.didichuxing.doraemonkit.util.ConvertUtils;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import com.facebook.imagepipeline.request.BasePostprocessor;
import com.facebook.imagepipeline.request.Postprocessor;

public class DokitFrescoPostprocessor
implements Postprocessor {
    private static final String TAG = "DokitPostprocessor";
    @Nullable
    private Postprocessor mOriginalPostprocessor;
    private Uri mUri;
    @Nullable
    private CacheKey mCacheKey;

    public DokitFrescoPostprocessor(Uri uri, Postprocessor postprocessor) {
        this.mOriginalPostprocessor = postprocessor;
        this.mUri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableReference<Bitmap> process(Bitmap sourceBitmap, PlatformBitmapFactory bitmapFactory) {
        try {
            if (PerformanceSpInfoConfig.isLargeImgOpen()) {
                double imgSize = ConvertUtils.byte2MemorySize((long)sourceBitmap.getByteCount(), (int)0x100000);
                LargePictureManager.getInstance().saveImageInfo(this.mUri.toString(), imgSize, sourceBitmap.getWidth(), sourceBitmap.getHeight(), "Fresco");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mOriginalPostprocessor != null) {
            return this.mOriginalPostprocessor.process(sourceBitmap, bitmapFactory);
        }
        Bitmap.Config sourceBitmapConfig = sourceBitmap.getConfig();
        CloseableReference destBitmapRef = bitmapFactory.createBitmapInternal(sourceBitmap.getWidth(), sourceBitmap.getHeight(), sourceBitmapConfig != null ? sourceBitmapConfig : BasePostprocessor.FALLBACK_BITMAP_CONFIGURATION);
        try {
            this.process((Bitmap)destBitmapRef.get(), sourceBitmap);
            CloseableReference closeableReference = CloseableReference.cloneOrNull((CloseableReference)destBitmapRef);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)destBitmapRef);
        }
    }

    public void process(Bitmap destBitmap, Bitmap sourceBitmap) {
        DokitFrescoPostprocessor.internalCopyBitmap(destBitmap, sourceBitmap);
        this.process(destBitmap);
    }

    public void process(Bitmap bitmap) {
    }

    private static void internalCopyBitmap(Bitmap destBitmap, Bitmap sourceBitmap) {
        if (destBitmap.getConfig() == sourceBitmap.getConfig()) {
            Bitmaps.copyBitmap((Bitmap)destBitmap, (Bitmap)sourceBitmap);
        } else {
            Canvas canvas = new Canvas(destBitmap);
            canvas.drawBitmap(sourceBitmap, 0.0f, 0.0f, null);
        }
    }

    public String getName() {
        if (this.mOriginalPostprocessor != null) {
            return this.mOriginalPostprocessor.getName();
        }
        return "DoKit&Fresco&DokitPostprocessor";
    }

    @Nullable
    public CacheKey getPostprocessorCacheKey() {
        if (this.mOriginalPostprocessor != null) {
            return this.mOriginalPostprocessor.getPostprocessorCacheKey();
        }
        if (this.mCacheKey == null) {
            this.mCacheKey = new SimpleCacheKey("DokitFrescoPostprocessor");
        }
        return this.mCacheKey;
    }
}

