/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.widget.Toast;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.didichuxing.doraemonkit.DokitActivityLifecycleCallbacks$WhenMappings;
import com.didichuxing.doraemonkit.DokitFragmentLifecycleCallbacks;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.datapick.DataPickManager;
import com.didichuxing.doraemonkit.kit.core.ActivityLifecycleStatusInfo;
import com.didichuxing.doraemonkit.kit.core.DoKitLifeCycleStatus;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.core.DokitViewManager;
import com.didichuxing.doraemonkit.kit.health.AppHealthInfoUtil;
import com.didichuxing.doraemonkit.kit.health.model.AppHealthInfo;
import com.didichuxing.doraemonkit.kit.uiperformance.UIPerformanceUtil;
import com.didichuxing.doraemonkit.model.ViewInfo;
import com.didichuxing.doraemonkit.util.DoKitPermissionUtil;
import com.didichuxing.doraemonkit.util.LifecycleListenerUtil;
import com.didichuxing.doraemonkit.util.UIUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/didichuxing/doraemonkit/DokitActivityLifecycleCallbacks;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "()V", "sFragmentLifecycleCallbacks", "Landroidx/fragment/app/FragmentManager$FragmentLifecycleCallbacks;", "sHasRequestPermission", "", "startedActivityCounts", "", "dispatchOnActivityResumed", "", "activity", "Landroid/app/Activity;", "onActivityCreated", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "recordActivityLifeCycleStatus", "lifeCycleStatus", "Lcom/didichuxing/doraemonkit/kit/core/DoKitLifeCycleStatus;", "recordActivityUiLevel", "requestPermission", "context", "Landroid/content/Context;", "Companion", "dokit_release"})
public final class DokitActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private int startedActivityCounts;
    private boolean sHasRequestPermission;
    private final FragmentManager.FragmentLifecycleCallbacks sFragmentLifecycleCallbacks = new DokitFragmentLifecycleCallbacks();
    private static final String TAG = "ActivityLifecycleCallback";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        try {
            this.recordActivityLifeCycleStatus(activity, DoKitLifeCycleStatus.CREATED);
            if (DokitActivityLifecycleCallbacks.Companion.ignoreCurrentActivityDokitView(activity)) {
                return;
            }
            if (activity instanceof FragmentActivity) {
                ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks(this.sFragmentLifecycleCallbacks, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        try {
            if (DokitActivityLifecycleCallbacks.Companion.ignoreCurrentActivityDokitView(activity)) {
                return;
            }
            if (this.startedActivityCounts == 0) {
                DokitViewManager.Companion.getInstance().notifyForeground();
            }
            int n = this.startedActivityCounts;
            this.startedActivityCounts = n + 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        try {
            this.recordActivityLifeCycleStatus(activity, DoKitLifeCycleStatus.RESUME);
            if (Intrinsics.areEqual((Object)activity.getClass().getCanonicalName(), (Object)"com.didichuxing.doraemonkit.kit.base.UniversalActivity") ^ true) {
                this.recordActivityUiLevel(activity);
            }
            if (DokitActivityLifecycleCallbacks.Companion.ignoreCurrentActivityDokitView(activity)) {
                return;
            }
            UIUtils.getDokitAppContentView(activity);
            this.dispatchOnActivityResumed(activity);
            for (LifecycleListenerUtil.LifecycleListener listener : LifecycleListenerUtil.LIFECYCLE_LISTENERS) {
                listener.onActivityResumed(activity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        try {
            if (DokitActivityLifecycleCallbacks.Companion.ignoreCurrentActivityDokitView(activity)) {
                return;
            }
            for (LifecycleListenerUtil.LifecycleListener listener : LifecycleListenerUtil.LIFECYCLE_LISTENERS) {
                listener.onActivityPaused(activity);
            }
            DokitViewManager.Companion.getInstance().onActivityPaused(activity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        try {
            this.recordActivityLifeCycleStatus(activity, DoKitLifeCycleStatus.STOPPED);
            if (DokitActivityLifecycleCallbacks.Companion.ignoreCurrentActivityDokitView(activity)) {
                return;
            }
            int n = this.startedActivityCounts;
            this.startedActivityCounts = n + -1;
            if (this.startedActivityCounts == 0) {
                DokitViewManager.Companion.getInstance().notifyBackground();
                DataPickManager.getInstance().postData();
            }
            DokitViewManager.Companion.getInstance().onActivityStopped(activity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @Nullable Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        try {
            if (DokitActivityLifecycleCallbacks.Companion.ignoreCurrentActivityDokitView(activity)) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        try {
            this.recordActivityLifeCycleStatus(activity, DoKitLifeCycleStatus.DESTROYED);
            if (DokitActivityLifecycleCallbacks.Companion.ignoreCurrentActivityDokitView(activity)) {
                return;
            }
            if (activity instanceof FragmentActivity) {
                ((FragmentActivity)activity).getSupportFragmentManager().unregisterFragmentLifecycleCallbacks(this.sFragmentLifecycleCallbacks);
            }
            DokitViewManager.Companion.getInstance().onActivityDestroyed(activity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void dispatchOnActivityResumed(Activity activity) {
        if (DoKitManager.IS_NORMAL_FLOAT_MODE) {
            DokitViewManager.Companion.getInstance().dispatchOnActivityResumed(activity);
        } else if (DoKitPermissionUtil.canDrawOverlays((Context)activity)) {
            DokitViewManager.Companion.getInstance().dispatchOnActivityResumed(activity);
        } else {
            this.requestPermission((Context)activity);
        }
    }

    private final void requestPermission(Context context) {
        if (!DoKitPermissionUtil.canDrawOverlays(context) && !this.sHasRequestPermission) {
            Toast.makeText((Context)context, (CharSequence)context.getText(R.string.dk_float_permission_toast), (int)0).show();
            DoKitPermissionUtil.requestDrawOverlays(context);
            this.sHasRequestPermission = true;
        }
    }

    private final void recordActivityUiLevel(Activity activity) {
        try {
            if (!DoKitManager.APP_HEALTH_RUNNING) {
                return;
            }
            List<ViewInfo> viewInfos = UIPerformanceUtil.getViewInfos(activity);
            int maxLevel = 0;
            float maxTime = 0.0f;
            float totalTime = 0.0f;
            ViewInfo maxLevelViewInfo = null;
            ViewInfo maxTimeViewInfo = null;
            for (ViewInfo viewInfo : viewInfos) {
                if (viewInfo.layerNum > maxLevel) {
                    maxLevel = viewInfo.layerNum;
                    maxLevelViewInfo = viewInfo;
                }
                if (viewInfo.drawTime > maxTime) {
                    maxTime = viewInfo.drawTime;
                    maxTimeViewInfo = viewInfo;
                }
                totalTime += viewInfo.drawTime;
            }
            String detail = StringsKt.trimIndent((String)("\n                \u6700\u5927\u5c42\u7ea7:" + maxLevel + "\n                \u63a7\u4ef6id:" + (maxLevelViewInfo == null ? "no id" : maxLevelViewInfo.id) + "\n                \u603b\u7ed8\u5236\u8017\u65f6:" + totalTime + "ms\n                \u7ed8\u5236\u8017\u65f6\u6700\u957f\u63a7\u4ef6:" + maxTime + "ms\n                \u7ed8\u5236\u8017\u65f6\u6700\u957f\u63a7\u4ef6id:" + (maxTimeViewInfo == null ? "no id" : maxTimeViewInfo.id) + "\n                \n                "));
            AppHealthInfo.DataBean.UiLevelBean uiLevelBean = new AppHealthInfo.DataBean.UiLevelBean();
            uiLevelBean.setPage(activity.getClass().getCanonicalName());
            uiLevelBean.setLevel("" + maxLevel);
            uiLevelBean.setDetail(detail);
            AppHealthInfoUtil.getInstance().addUiLevelInfo(uiLevelBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void recordActivityLifeCycleStatus(Activity activity, DoKitLifeCycleStatus lifeCycleStatus) {
        Map<String, ActivityLifecycleStatusInfo> map = DoKitManager.INSTANCE.getACTIVITY_LIFECYCLE_INFOS();
        String string2 = activity.getClass().getCanonicalName();
        boolean bl = false;
        ActivityLifecycleStatusInfo activityLifeCycleStatusInfo = map.get(string2);
        if (activityLifeCycleStatusInfo == null) {
            activityLifeCycleStatusInfo = new ActivityLifecycleStatusInfo(false, DoKitLifeCycleStatus.CREATED, activity.getClass().getCanonicalName());
            Map<String, ActivityLifecycleStatusInfo> map2 = DoKitManager.INSTANCE.getACTIVITY_LIFECYCLE_INFOS();
            String string3 = activity.getClass().getCanonicalName();
            Intrinsics.checkNotNull((Object)string3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activity.javaClass.canonicalName!!");
            map2.put(string3, activityLifeCycleStatusInfo);
        }
        switch (DokitActivityLifecycleCallbacks$WhenMappings.$EnumSwitchMapping$0[lifeCycleStatus.ordinal()]) {
            case 1: {
                activityLifeCycleStatusInfo.setLifeCycleStatus(DoKitLifeCycleStatus.CREATED);
                break;
            }
            case 2: {
                activityLifeCycleStatusInfo.setLifeCycleStatus(DoKitLifeCycleStatus.RESUME);
                break;
            }
            case 3: {
                activityLifeCycleStatusInfo.setLifeCycleStatus(DoKitLifeCycleStatus.STOPPED);
                activityLifeCycleStatusInfo.setInvokeStopMethod(true);
                break;
            }
            case 4: {
                map = DoKitManager.INSTANCE.getACTIVITY_LIFECYCLE_INFOS();
                string2 = activity.getClass().getCanonicalName();
                bl = false;
                Map<String, ActivityLifecycleStatusInfo> map3 = map;
                if (map3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                }
                TypeIntrinsics.asMutableMap(map3).remove(string2);
                break;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/didichuxing/doraemonkit/DokitActivityLifecycleCallbacks$Companion;", "", "()V", "TAG", "", "ignoreCurrentActivityDokitView", "", "activity", "Landroid/app/Activity;", "dokit_release"})
    public static final class Companion {
        private final boolean ignoreCurrentActivityDokitView(Activity activity) {
            String[] ignoreActivityClassNames;
            for (String activityClassName : ignoreActivityClassNames = new String[]{"DisplayLeakActivity"}) {
                if (!Intrinsics.areEqual((Object)activity.getClass().getSimpleName(), (Object)activityClassName)) continue;
                return true;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

