/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.titlebar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.didichuxing.doraemonkit.R;

public class TitleBar
extends FrameLayout {
    private ImageView mLeftIcon;
    private TextView mTitle;
    private TextView mLeftText;
    private ImageView mRightIcon;
    private TextView mRightText;
    private OnTitleBarClickListener mListener;

    public TitleBar(@NonNull Context context) {
        this(context, null);
    }

    public TitleBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.dk_title_bar, (ViewGroup)this, true);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TitleBar);
        int leftIcon = a.getResourceId(R.styleable.TitleBar_dkLeftIcon, 0);
        int rightIcon = a.getResourceId(R.styleable.TitleBar_dkRightIcon, 0);
        int rightSubIcon = a.getResourceId(R.styleable.TitleBar_dkRightSubIcon, 0);
        String title = a.getString(R.styleable.TitleBar_dkTitle);
        int titleColor = a.getColor(R.styleable.TitleBar_dkTitleColor, 0);
        int titleBackground = a.getColor(R.styleable.TitleBar_dkTitleBackground, this.getResources().getColor(R.color.dk_color_FFFFFF));
        String rightText = a.getString(R.styleable.TitleBar_dkRightText);
        String leftText = a.getString(R.styleable.TitleBar_dkLeftText);
        a.recycle();
        this.mLeftIcon = (ImageView)this.findViewById(R.id.left_icon);
        this.mRightIcon = (ImageView)this.findViewById(R.id.right_icon);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mRightText = (TextView)this.findViewById(R.id.right_text);
        this.mLeftText = (TextView)this.findViewById(R.id.left_text);
        ((ViewGroup)this.mLeftIcon.getParent()).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TitleBar.this.mListener != null) {
                    TitleBar.this.mListener.onLeftClick();
                }
            }
        });
        if (rightSubIcon == 0) {
            ((ViewGroup)this.mRightIcon.getParent()).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (TitleBar.this.mListener != null) {
                        TitleBar.this.mListener.onRightClick();
                    }
                }
            });
            ((ViewGroup)this.mRightText.getParent()).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TitleBar.this.mListener != null) {
                        TitleBar.this.mListener.onRightClick();
                    }
                }
            });
        } else {
            this.mRightIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TitleBar.this.mListener != null) {
                        TitleBar.this.mListener.onRightClick();
                    }
                }
            });
        }
        this.setLeftIcon(leftIcon);
        this.setLeftText(leftText);
        this.setRightText(rightText);
        this.setRightIcon(rightIcon);
        this.setRightTextColor(titleColor);
        this.setTitle(title);
        this.setTitleColor(titleColor);
        this.setBackgroundColor(titleBackground);
    }

    private void setRightTextColor(int titleColor) {
        if (titleColor == 0) {
            return;
        }
        this.mRightText.setTextColor(titleColor);
        this.mRightText.setVisibility(0);
    }

    private void setTitleColor(int titleColor) {
        if (titleColor == 0) {
            return;
        }
        this.mTitle.setTextColor(titleColor);
        this.mTitle.setVisibility(0);
    }

    public void setTitle(String title) {
        this.setTitle(title, true);
    }

    public void setTitle(String title, boolean alpha) {
        if (TextUtils.isEmpty((CharSequence)title)) {
            this.mTitle.setText((CharSequence)"");
        } else {
            this.mTitle.setText((CharSequence)title);
            this.mTitle.setVisibility(0);
            if (alpha) {
                this.mTitle.setAlpha(0.0f);
                this.mTitle.animate().alpha(1.0f).start();
            }
        }
    }

    public void setTitle(@StringRes int title) {
        this.setTitle(this.getResources().getString(title));
    }

    public void setTitleImage(int resId) {
        this.mTitle.setBackgroundResource(resId);
        this.mTitle.setVisibility(0);
    }

    public void setOnTitleBarClickListener(OnTitleBarClickListener listener) {
        this.mListener = listener;
    }

    public void setLeftIcon(@DrawableRes int id2) {
        if (id2 == 0) {
            return;
        }
        this.mLeftIcon.setImageResource(id2);
        this.mLeftIcon.setVisibility(0);
    }

    public void setRightIcon(@DrawableRes int id2) {
        if (id2 == 0) {
            return;
        }
        this.mRightIcon.setImageResource(id2);
        this.mRightIcon.setVisibility(0);
    }

    public void setRightIcon(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        this.mRightIcon.setImageBitmap(bitmap);
        this.mRightIcon.setVisibility(0);
        this.mRightText.setVisibility(8);
    }

    public View getLeftView() {
        return this.mLeftIcon;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }

    public void setRightText(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.mRightText.setText((CharSequence)text);
        this.mRightText.setVisibility(0);
        this.mRightIcon.setVisibility(8);
    }

    public void setLeftText(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.mLeftText.setText((CharSequence)text);
        this.mLeftText.setVisibility(0);
    }

    public void hideRight() {
        this.mRightText.setVisibility(8);
        this.mRightIcon.setVisibility(8);
    }

    public ImageView getRightIcon() {
        return this.mRightIcon;
    }

    public TextView getRightText() {
        return this.mRightText;
    }

    public ImageView getLeftIcon() {
        return this.mLeftIcon;
    }

    public static interface OnTitleBarCheckListener {
        public void onCheckChange(boolean var1);
    }

    public static interface OnTitleBarClickListener {
        public void onLeftClick();

        public void onRightClick();
    }
}

