/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.titlebar;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.didichuxing.doraemonkit.R;

public class LogTitleBar
extends FrameLayout {
    private OnTitleBarClickListener mListener;
    private TextView mBack;
    private TextView mTitle;
    private ImageView mIcon;

    public LogTitleBar(@NonNull Context context) {
        this(context, null);
    }

    public LogTitleBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LogTitleBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.dk_log_title_bar, (ViewGroup)this, true);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.LogTitleBar);
        int icon = a.getResourceId(R.styleable.LogTitleBar_dkIcon, 0);
        String title = a.getString(R.styleable.LogTitleBar_dkTitle);
        String back = a.getString(R.styleable.LogTitleBar_dkBack);
        a.recycle();
        this.mBack = (TextView)this.findViewById(R.id.back);
        this.mIcon = (ImageView)this.findViewById(R.id.icon);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LogTitleBar.this.mListener != null) {
                    LogTitleBar.this.mListener.onRightClick();
                }
            }
        });
        this.mBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LogTitleBar.this.mListener != null) {
                    LogTitleBar.this.mListener.onLeftClick();
                }
            }
        });
        this.setBack(back);
        this.setTitle(title);
        this.setIcon(icon);
    }

    public void setTitle(@StringRes int title) {
        this.setTitle(this.getResources().getString(title));
    }

    public void setTitle(String title) {
        if (TextUtils.isEmpty((CharSequence)title)) {
            this.mTitle.setText((CharSequence)"");
        } else {
            this.mTitle.setText((CharSequence)title);
            this.mTitle.setAlpha(0.0f);
            this.mTitle.setVisibility(0);
            this.mTitle.animate().alpha(1.0f).start();
        }
    }

    public void setBack(String back) {
        if (TextUtils.isEmpty((CharSequence)back)) {
            this.mBack.setText((CharSequence)"");
        } else {
            this.mBack.setText((CharSequence)back);
        }
    }

    public void setIcon(@DrawableRes int id2) {
        if (id2 == 0) {
            return;
        }
        this.mIcon.setImageResource(id2);
        this.mIcon.setVisibility(0);
    }

    public void setListener(OnTitleBarClickListener listener) {
        this.mListener = listener;
    }

    public static interface OnTitleBarClickListener {
        public void onRightClick();

        public void onLeftClick();
    }
}

