/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.easyrefresh;

import android.text.TextUtils;
import android.util.Log;

public final class ELog {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static boolean isEnabled = true;

    private ELog() {
    }

    public static void setEnable(boolean enableBoolean) {
        isEnabled = enableBoolean;
    }

    public static boolean isEnable() {
        return isEnabled;
    }

    private static void log(LEVEL level, String tag, String msg, Throwable thr) {
        if (!isEnabled) {
            return;
        }
        ELog.log2console(level, tag, msg, thr);
    }

    private static void log2console(LEVEL level, String tag, String msg, Throwable thr) {
        boolean isFilter = false;
        if (!isFilter) {
            switch (level) {
                case VERBOSE: {
                    if (thr == null) {
                        Log.v((String)tag, (String)msg);
                        break;
                    }
                    Log.v((String)tag, (String)msg, (Throwable)thr);
                    break;
                }
                case DEBUG: {
                    if (thr == null) {
                        Log.d((String)tag, (String)msg);
                        break;
                    }
                    Log.d((String)tag, (String)msg, (Throwable)thr);
                    break;
                }
                case INFO: {
                    if (thr == null) {
                        Log.i((String)tag, (String)msg);
                        break;
                    }
                    Log.i((String)tag, (String)msg, (Throwable)thr);
                    break;
                }
                case WARN: {
                    if (thr == null) {
                        Log.w((String)tag, (String)msg);
                        break;
                    }
                    if (TextUtils.isEmpty((CharSequence)msg)) {
                        Log.w((String)tag, (Throwable)thr);
                        break;
                    }
                    Log.w((String)tag, (String)msg, (Throwable)thr);
                    break;
                }
                case ERROR: {
                    if (thr == null) {
                        Log.e((String)tag, (String)msg);
                        break;
                    }
                    Log.e((String)tag, (String)msg, (Throwable)thr);
                    break;
                }
                case ASSERT: {
                    if (thr == null) {
                        Log.wtf((String)tag, (String)msg);
                        break;
                    }
                    if (TextUtils.isEmpty((CharSequence)msg)) {
                        Log.wtf((String)tag, (Throwable)thr);
                        break;
                    }
                    Log.wtf((String)tag, (String)msg, (Throwable)thr);
                    break;
                }
            }
        } else {
            return;
        }
    }

    public static void v(String tag, String msg) {
        ELog.log(LEVEL.VERBOSE, tag, msg, null);
    }

    public static void v(String tag, String msg, Throwable thr) {
        ELog.log(LEVEL.VERBOSE, tag, msg, thr);
    }

    public static void d(String tag, String msg) {
        ELog.log(LEVEL.DEBUG, tag, msg, null);
    }

    public static void d(String tag, String msg, Throwable thr) {
        ELog.log(LEVEL.DEBUG, tag, msg, thr);
    }

    public static void i(String tag, String msg) {
        ELog.log(LEVEL.INFO, tag, msg, null);
    }

    public static void i(String tag, String msg, Throwable thr) {
        ELog.log(LEVEL.INFO, tag, msg, thr);
    }

    public static void w(String tag, String msg) {
        ELog.log(LEVEL.WARN, tag, msg, null);
    }

    public static void w(String tag, String msg, Throwable thr) {
        ELog.log(LEVEL.WARN, tag, msg, thr);
    }

    public static void w(String tag, Throwable thr) {
        ELog.log(LEVEL.WARN, tag, "", thr);
    }

    public static void e(String tag, String msg) {
        ELog.log(LEVEL.ERROR, tag, msg, null);
    }

    public static void e(String tag, String msg, Throwable thr) {
        ELog.log(LEVEL.ERROR, tag, msg, thr);
    }

    public static enum LEVEL {
        VERBOSE(2, "V"),
        DEBUG(3, "D"),
        INFO(4, "I"),
        WARN(5, "W"),
        ERROR(6, "E"),
        ASSERT(7, "A");

        final String levelString;
        final int level;

        private LEVEL() {
            throw new AssertionError();
        }

        private LEVEL(int level, String levelString) {
            this.level = level;
            this.levelString = levelString;
        }

        public String getLevelString() {
            return this.levelString;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

