/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.dialog;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentManager;
import com.didichuxing.doraemonkit.widget.dialog.DialogListener;

public abstract class DialogProvider<T> {
    private T mData;
    private DialogFragment mHost;
    private View mView;
    private DialogListener mDialogListener;
    private boolean cancellable = true;

    public DialogProvider(T data, DialogListener listener) {
        this.mDialogListener = listener;
        this.mData = data;
    }

    public void setHost(DialogFragment host) {
        this.mHost = host;
    }

    public DialogFragment getHost() {
        return this.mHost;
    }

    public Context getContext() {
        if (this.mHost == null) {
            return null;
        }
        return this.mHost.getContext();
    }

    public abstract int getLayoutId();

    public final View createView(LayoutInflater inflater, ViewGroup parent) {
        this.mView = inflater.inflate(this.getLayoutId(), parent, false);
        return this.mView;
    }

    public final void onViewCreated(View view) {
        this.findViews(view);
        this.registerForListeners();
        this.bindData(this.mData);
    }

    protected void bindData(T data) {
    }

    protected abstract void findViews(View var1);

    private void registerForListeners() {
        View cancelView;
        View negativeView;
        View positiveView = this.getPositiveView();
        if (positiveView != null) {
            positiveView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DialogProvider.this.onPositive();
                }
            });
        }
        if ((negativeView = this.getNegativeView()) != null) {
            negativeView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DialogProvider.this.onNegative();
                }
            });
        }
        if ((cancelView = this.getCancelView()) != null) {
            cancelView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DialogProvider.this.cancel();
                }
            });
        }
    }

    private void onPositive() {
        boolean dismiss = true;
        if (this.mDialogListener != null) {
            dismiss = this.mDialogListener.onPositive(this);
        }
        if (dismiss) {
            this.dismiss();
        }
    }

    private void onNegative() {
        boolean dismiss = true;
        if (this.mDialogListener != null) {
            dismiss = this.mDialogListener.onNegative(this);
        }
        if (dismiss) {
            this.dismiss();
        }
    }

    public void show(FragmentManager childFragmentManager) {
        this.mHost.show(childFragmentManager, null);
    }

    public void dismiss() {
        this.mHost.dismiss();
    }

    protected void cancel() {
        this.dismiss();
        if (this.mDialogListener != null) {
            this.mDialogListener.onCancel(this);
        }
    }

    void onCancel() {
        if (this.mDialogListener != null) {
            this.mDialogListener.onCancel(this);
        }
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public void setCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    protected View getPositiveView() {
        return null;
    }

    protected View getNegativeView() {
        return null;
    }

    protected View getCancelView() {
        return null;
    }

    public void setDialogListener(DialogListener dialogListener) {
        this.mDialogListener = dialogListener;
    }
}

