/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util.threadpool;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolProxy {
    ThreadPoolExecutor mExecutor;
    private int mCorePoolSize;
    private int mMaximumPoolSize;

    public ThreadPoolProxy(int corePoolSize, int maximumPoolSize) {
        this.mCorePoolSize = corePoolSize;
        this.mMaximumPoolSize = maximumPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initThreadPoolExecutor() {
        if (this.mExecutor != null && !this.mExecutor.isShutdown() && !this.mExecutor.isTerminated()) return;
        Class<ThreadPoolProxy> clazz = ThreadPoolProxy.class;
        synchronized (ThreadPoolProxy.class) {
            if (this.mExecutor != null && !this.mExecutor.isShutdown() && !this.mExecutor.isTerminated()) return;
            long keepAliveTime = 3000L;
            TimeUnit unit = TimeUnit.MILLISECONDS;
            LinkedBlockingDeque<Runnable> workQueue = new LinkedBlockingDeque<Runnable>();
            ThreadFactory threadFactory = Executors.defaultThreadFactory();
            ThreadPoolExecutor.DiscardPolicy handler = new ThreadPoolExecutor.DiscardPolicy();
            this.mExecutor = new ThreadPoolExecutor(this.mCorePoolSize, this.mMaximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void execute(Runnable task) {
        this.initThreadPoolExecutor();
        this.mExecutor.execute(task);
    }

    public Future submit(Runnable task) {
        this.initThreadPoolExecutor();
        return this.mExecutor.submit(task);
    }

    public void remove(Runnable task) {
        this.initThreadPoolExecutor();
        this.mExecutor.remove(task);
    }
}

