/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.hardware.Camera;
import android.location.Location;
import android.location.LocationManager;
import android.media.AudioRecord;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.provider.ContactsContract;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.didichuxing.doraemonkit.util.LogHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DoKitPermissionUtil {
    private static final String TAG = "PermissionUtil";
    private static final int AUDIO_INPUT = 1;
    private static final int AUDIO_SAMPLE_RATE = 16000;
    private static final int AUDIO_CHANNEL = 16;
    private static final int AUDIO_ENCODING = 2;
    private static final int OP_SYSTEM_ALERT_WINDOW = 24;

    private DoKitPermissionUtil() {
    }

    public static boolean canDrawOverlays(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Settings.canDrawOverlays((Context)context);
        }
        return DoKitPermissionUtil.checkOp(context, 24);
    }

    private static boolean checkOp(Context context, int op) {
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager manager = (AppOpsManager)context.getSystemService("appops");
            Class<AppOpsManager> clazz = AppOpsManager.class;
            try {
                Method method = clazz.getDeclaredMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
                return 0 == (Integer)method.invoke((Object)manager, op, Process.myUid(), context.getPackageName());
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void requestDrawOverlays(Context context) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + context.getPackageName())));
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        if (intent.resolveActivity(context.getPackageManager()) != null) {
            context.startActivity(intent);
        } else {
            LogHelper.e(TAG, "No activity to handle intent");
        }
    }

    public static boolean isMockLocationEnabled(Context context) {
        boolean isMockLocation = false;
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                AppOpsManager opsManager = (AppOpsManager)context.getSystemService("appops");
                if (opsManager != null) {
                    isMockLocation = opsManager.checkOp("android:mock_location", Process.myUid(), context.getPackageName()) == 0;
                }
            } else {
                isMockLocation = !Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"mock_location").equals("0");
            }
        }
        catch (Exception e) {
            return false;
        }
        return isMockLocation;
    }

    public static boolean hasPermissions(@NonNull Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        if (context == null) {
            throw new IllegalArgumentException("Can't check permissions for null context");
        }
        for (String perm : perms) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkStorageUnreliable() {
        FileOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            File file = new File(Environment.getExternalStorageDirectory() + File.separator + ".DoraemonkitTest.kit");
            outputStream = new FileOutputStream(file);
            outputStream.write(1);
            outputStream.flush();
            outputStream.close();
            outputStream = null;
            inputStream = new FileInputStream(file);
            inputStream.read();
            inputStream.close();
            inputStream = null;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean checkLocationUnreliable(Context context) {
        try {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return false;
            }
            Location location = locationManager.getLastKnownLocation("gps");
            Location location2 = locationManager.getLastKnownLocation("network");
            return location != null || location2 != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkCameraUnreliable() {
        Camera camera = null;
        try {
            camera = Camera.open();
            boolean bl = camera != null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (camera != null) {
                try {
                    camera.release();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkRecordUnreliable() {
        AudioRecord audioRecord = null;
        int bufferSizeInBytes = AudioRecord.getMinBufferSize((int)16000, (int)16, (int)2);
        try {
            audioRecord = new AudioRecord(1, 16000, 16, 2, bufferSizeInBytes);
            boolean bl = audioRecord != null && audioRecord.getState() == 1;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (audioRecord != null) {
                try {
                    audioRecord.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean checkReadPhoneUnreliable(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            String imei = tm.getDeviceId();
            return !TextUtils.isEmpty((CharSequence)imei);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkReadContactUnreliable(Context context) {
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, null, null, null);
            if (cursor != null && cursor.moveToNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

