/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DoKitCacheUtils {
    private static final String TAG = "CacheUtils";

    public static boolean saveObject(String key, Serializable ser) {
        File file = new File(Utils.getApp().getCacheDir() + "/" + key);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return DoKitCacheUtils.saveObject(ser, file);
    }

    public static Serializable readObject(String key) {
        File file = new File(Utils.getApp().getCacheDir() + "/" + key);
        return DoKitCacheUtils.readObject(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveObject(Serializable ser, File file) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(ser);
            oos.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable readObject(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            Serializable serializable = (Serializable)ois.readObject();
            return serializable;
        }
        catch (IOException e) {
            if (e instanceof InvalidClassException) {
                file.delete();
            }
            e.printStackTrace();
            Serializable serializable = null;
            return serializable;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Serializable serializable = null;
            return serializable;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LogHelper.e(TAG, e.toString());
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    LogHelper.e(TAG, e.toString());
                }
            }
        }
    }
}

