/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.picasso;

import android.content.Context;
import android.media.ExifInterface;
import android.net.Uri;
import com.didichuxing.doraemonkit.picasso.ContentStreamRequestHandler;
import com.didichuxing.doraemonkit.picasso.DokitPicasso;
import com.didichuxing.doraemonkit.picasso.Request;
import com.didichuxing.doraemonkit.picasso.RequestHandler;
import java.io.IOException;

class FileRequestHandler
extends ContentStreamRequestHandler {
    FileRequestHandler(Context context) {
        super(context);
    }

    @Override
    public boolean canHandleRequest(Request data) {
        return "file".equals(data.uri.getScheme());
    }

    @Override
    public RequestHandler.Result load(Request request2, int networkPolicy) throws IOException {
        return new RequestHandler.Result(null, this.getInputStream(request2), DokitPicasso.LoadedFrom.DISK, FileRequestHandler.getFileExifRotation(request2.uri));
    }

    static int getFileExifRotation(Uri uri) throws IOException {
        ExifInterface exifInterface = new ExifInterface(uri.getPath());
        int orientation = exifInterface.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }
}

