/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.weaknetwork;

import android.app.Activity;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.core.SettingItemAdapter;
import com.didichuxing.doraemonkit.kit.weaknetwork.NetWokDokitView;
import com.didichuxing.doraemonkit.kit.weaknetwork.WeakNetworkManager;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;

public class WeakNetworkFragment
extends BaseFragment
implements TextWatcher {
    private SettingItemAdapter mSettingItemAdapter;
    private RecyclerView mSettingList;
    private View mWeakNetworkOptionView;
    private View mTimeoutOptionView;
    private View mSpeedLimitView;
    private EditText mTimeoutValueView;
    private EditText mRequestSpeedView;
    private EditText mResponseSpeedView;
    private AbsDokitView mNetWorkDokitView;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_weak_network;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    private void initView() {
        HomeTitleBar homeTitleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        homeTitleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                WeakNetworkFragment.this.getActivity().finish();
            }
        });
        this.mWeakNetworkOptionView = this.findViewById(R.id.weak_network_layout);
        this.mSettingList = (RecyclerView)this.findViewById(R.id.setting_list);
        this.mSettingList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mSettingItemAdapter = new SettingItemAdapter(this.getContext());
        this.mSettingList.setAdapter((RecyclerView.Adapter)this.mSettingItemAdapter);
        this.mSettingItemAdapter.append(new SettingItem(R.string.dk_weak_network_switch, WeakNetworkManager.get().isActive()));
        this.mSettingItemAdapter.setOnSettingItemSwitchListener(new SettingItemAdapter.OnSettingItemSwitchListener(){

            @Override
            public void onSettingItemSwitch(View view, SettingItem data, boolean on) {
                if (data.desc == R.string.dk_weak_network_switch) {
                    WeakNetworkFragment.this.setWeakNetworkEnabled(data.isChecked);
                }
            }
        });
        RadioGroup optionGroup = (RadioGroup)this.findViewById(R.id.weak_network_option);
        optionGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                if (R.id.timeout == checkedId) {
                    WeakNetworkFragment.this.showTimeoutOptionView();
                } else if (R.id.speed_limit == checkedId) {
                    WeakNetworkFragment.this.showSpeedLimitOptionView();
                } else {
                    WeakNetworkFragment.this.showOffNetworkOptionView();
                }
                if (WeakNetworkFragment.this.mNetWorkDokitView == null) {
                    WeakNetworkFragment.this.mNetWorkDokitView = DoKit.getDoKitView((Activity)WeakNetworkFragment.this.getActivity(), NetWokDokitView.class);
                }
                if (WeakNetworkFragment.this.mNetWorkDokitView != null) {
                    WeakNetworkFragment.this.mNetWorkDokitView.onResume();
                }
            }
        });
        this.mTimeoutOptionView = this.findViewById(R.id.layout_timeout_option);
        this.mSpeedLimitView = this.findViewById(R.id.layout_speed_limit);
        this.mTimeoutValueView = (EditText)this.findViewById(R.id.value_timeout);
        this.mTimeoutValueView.addTextChangedListener((TextWatcher)this);
        this.mRequestSpeedView = (EditText)this.findViewById(R.id.request_speed);
        this.mRequestSpeedView.addTextChangedListener((TextWatcher)this);
        this.mResponseSpeedView = (EditText)this.findViewById(R.id.response_speed);
        this.mResponseSpeedView.addTextChangedListener((TextWatcher)this);
        this.updateUIState();
    }

    private void updateUIState() {
        boolean active = WeakNetworkManager.get().isActive();
        this.mWeakNetworkOptionView.setVisibility(active ? 0 : 8);
        if (active) {
            int checkButtonId;
            int type = WeakNetworkManager.get().getType();
            switch (type) {
                case 1: {
                    checkButtonId = R.id.timeout;
                    break;
                }
                case 2: {
                    checkButtonId = R.id.speed_limit;
                    break;
                }
                default: {
                    checkButtonId = R.id.off_network;
                }
            }
            RadioButton defaultOptionView = (RadioButton)this.findViewById(checkButtonId);
            defaultOptionView.setChecked(true);
            this.mTimeoutValueView.setHint((CharSequence)String.valueOf(WeakNetworkManager.get().getTimeOutMillis()));
            this.mRequestSpeedView.setHint((CharSequence)String.valueOf(WeakNetworkManager.get().getRequestSpeed()));
            this.mResponseSpeedView.setHint((CharSequence)String.valueOf(WeakNetworkManager.get().getResponseSpeed()));
        }
    }

    private void setWeakNetworkEnabled(boolean enabled) {
        WeakNetworkManager.get().setActive(enabled);
        this.updateUIState();
        if (enabled) {
            DoKit.launchFloating(NetWokDokitView.class);
        } else {
            DoKit.removeFloating(NetWokDokitView.class);
        }
    }

    private void showTimeoutOptionView() {
        this.mTimeoutOptionView.setVisibility(0);
        this.mSpeedLimitView.setVisibility(8);
        WeakNetworkManager.get().setType(1);
    }

    private void showSpeedLimitOptionView() {
        this.mSpeedLimitView.setVisibility(0);
        this.mTimeoutOptionView.setVisibility(8);
        WeakNetworkManager.get().setType(2);
    }

    private void showOffNetworkOptionView() {
        this.mSpeedLimitView.setVisibility(8);
        this.mTimeoutOptionView.setVisibility(8);
        WeakNetworkManager.get().setType(0);
    }

    private long getLongValue(EditText editText) {
        Editable text = editText.getText();
        if (TextUtils.isEmpty((CharSequence)text)) {
            return 0L;
        }
        return Long.parseLong(text.toString());
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        long timeOutMillis = this.getLongValue(this.mTimeoutValueView);
        long requestSpeed = this.getLongValue(this.mRequestSpeedView);
        long responseSpeed = this.getLongValue(this.mResponseSpeedView);
        WeakNetworkManager.get().setParameter(timeOutMillis, requestSpeed, responseSpeed);
    }

    public void afterTextChanged(Editable s) {
    }
}

