/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.weaknetwork;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.kit.weaknetwork.WeakNetworkManager;
import com.didichuxing.doraemonkit.util.DoKitCommUtil;

public class NetWokDokitView
extends AbsDokitView {
    TextView mTvNetWork;
    TextView mTvTimeOutTime;
    TextView mTvRequestSpeed;
    TextView mTvResponseSpeed;
    LinearLayout mLlTimeWrap;
    LinearLayout mLlSpeedWrap;
    ImageView mIvClose;

    @Override
    public void onCreate(Context context) {
    }

    @Override
    public View onCreateView(Context context, FrameLayout rootView) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_float_network, (ViewGroup)rootView, false);
    }

    @Override
    public void onViewCreated(FrameLayout rootView) {
        this.mTvNetWork = (TextView)rootView.findViewById(R.id.tv_net_type);
        this.mTvTimeOutTime = (TextView)rootView.findViewById(R.id.tv_time);
        this.mTvRequestSpeed = (TextView)rootView.findViewById(R.id.tv_request_speed);
        this.mTvResponseSpeed = (TextView)rootView.findViewById(R.id.tv_response_speed);
        this.mLlTimeWrap = (LinearLayout)rootView.findViewById(R.id.ll_timeout_wrap);
        this.mLlSpeedWrap = (LinearLayout)rootView.findViewById(R.id.ll_speed_wrap);
        this.mIvClose = (ImageView)rootView.findViewById(R.id.iv_close);
        this.mIvClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WeakNetworkManager.get().setActive(false);
                DoKit.removeFloating(NetWokDokitView.class);
            }
        });
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.width = DokitViewLayoutParams.WRAP_CONTENT;
        params.height = DokitViewLayoutParams.WRAP_CONTENT;
        params.gravity = 51;
        params.x = 100;
        params.y = 100;
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            if (this.mTvNetWork == null) {
                return;
            }
            int type = WeakNetworkManager.get().getType();
            switch (type) {
                case 1: {
                    this.mTvNetWork.setText((CharSequence)DoKitCommUtil.getString(R.string.dk_weaknet_type_timeout));
                    this.mTvTimeOutTime.setText((CharSequence)("" + WeakNetworkManager.get().getTimeOutMillis() + " ms"));
                    this.mLlTimeWrap.setVisibility(0);
                    this.mLlSpeedWrap.setVisibility(8);
                    break;
                }
                case 2: {
                    this.mTvNetWork.setText((CharSequence)DoKitCommUtil.getString(R.string.dk_weaknet_type_speed));
                    this.mTvRequestSpeed.setText((CharSequence)("" + WeakNetworkManager.get().getRequestSpeed() + " KB/S"));
                    this.mTvResponseSpeed.setText((CharSequence)("" + WeakNetworkManager.get().getResponseSpeed() + " KB/S"));
                    this.mLlTimeWrap.setVisibility(8);
                    this.mLlSpeedWrap.setVisibility(0);
                    break;
                }
                default: {
                    this.mTvNetWork.setText((CharSequence)DoKitCommUtil.getString(R.string.dk_weaknet_type_off));
                    this.mLlTimeWrap.setVisibility(8);
                    this.mLlSpeedWrap.setVisibility(8);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.immInvalidate();
    }

    @Override
    public void immInvalidate() {
        if (this.getDoKitView() == null) {
            return;
        }
        if (this.isNormalMode()) {
            FrameLayout.LayoutParams layoutParams = this.getNormalLayoutParams();
            if (layoutParams == null) {
                return;
            }
            layoutParams.width = -2;
            layoutParams.height = -2;
            this.getDoKitView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else {
            WindowManager.LayoutParams layoutParams = this.getSystemLayoutParams();
            if (layoutParams == null) {
                return;
            }
            layoutParams.width = -2;
            layoutParams.height = -2;
            this.mWindowManager.updateViewLayout(this.getDoKitView(), (ViewGroup.LayoutParams)layoutParams);
        }
    }
}

