/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.viewcheck;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.model.ViewInfo;
import java.util.ArrayList;
import java.util.List;

public class LayoutBorderView
extends View {
    private static final String TAG1 = "LayoutBorderView";
    private Paint mRectPaint;
    private List<ViewInfo> mViewInfos = new ArrayList<ViewInfo>();

    public LayoutBorderView(Context context) {
        this(context, null);
    }

    public LayoutBorderView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LayoutBorderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    private void initView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.LayoutBorderView);
        boolean fill = a.getBoolean(R.styleable.LayoutBorderView_dkFill, false);
        this.mRectPaint = new Paint();
        if (fill) {
            this.mRectPaint.setStyle(Paint.Style.FILL);
            this.mRectPaint.setColor(-65536);
        } else {
            this.mRectPaint.setStyle(Paint.Style.STROKE);
            this.mRectPaint.setStrokeWidth(4.0f);
            this.mRectPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{4.0f, 4.0f}, 0.0f));
            this.mRectPaint.setColor(-65536);
        }
        a.recycle();
    }

    protected void onDraw(Canvas canvas) {
        for (ViewInfo viewInfo : this.mViewInfos) {
            if (this.mRectPaint.getStyle() == Paint.Style.FILL) {
                this.mRectPaint.setAlpha(viewInfo.getDrawTimeLevel() * 255);
            }
            canvas.drawRect(viewInfo.viewRect, this.mRectPaint);
        }
    }

    public void showViewLayoutBorder(ViewInfo info) {
        this.mViewInfos.clear();
        if (info != null) {
            this.mViewInfos.add(info);
        }
        this.invalidate();
    }

    public void showViewLayoutBorder(List<ViewInfo> viewInfos) {
        if (viewInfos == null) {
            return;
        }
        this.mViewInfos.clear();
        this.mViewInfos.addAll(viewInfos);
        this.invalidate();
    }
}

