/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.timecounter;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.timecounter.TimeCounterListAdapter;
import com.didichuxing.doraemonkit.kit.timecounter.TimeCounterManager;
import com.didichuxing.doraemonkit.kit.timecounter.bean.CounterInfo;
import com.didichuxing.doraemonkit.widget.recyclerview.DividerItemDecoration;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class TimeCounterListFragment
extends BaseFragment {
    private static final String TAG = "TimeCounterListFragment";
    private RecyclerView mBlockList;
    private TimeCounterListAdapter mAdapter;
    private TitleBar mTitleBar;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_time_counter_list;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
        this.load();
    }

    private void initView() {
        this.mBlockList = (RecyclerView)this.findViewById(R.id.block_list);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mBlockList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mAdapter = new TimeCounterListAdapter(this.getContext());
        this.mBlockList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        DividerItemDecoration decoration = new DividerItemDecoration(1);
        decoration.setDrawable(this.getResources().getDrawable(R.drawable.dk_divider));
        this.mBlockList.addItemDecoration((RecyclerView.ItemDecoration)decoration);
        this.mTitleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
        this.mTitleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

            @Override
            public void onLeftClick() {
                TimeCounterListFragment.this.getActivity().onBackPressed();
            }

            @Override
            public void onRightClick() {
            }
        });
    }

    private void load() {
        ArrayList<CounterInfo> infos = new ArrayList<CounterInfo>(TimeCounterManager.get().getHistory());
        infos.add(0, TimeCounterManager.get().getAppSetupInfo());
        Collections.sort(infos, new Comparator<CounterInfo>(){

            @Override
            public int compare(CounterInfo lhs, CounterInfo rhs) {
                return Long.valueOf(rhs.time).compareTo(lhs.time);
            }
        });
        this.mAdapter.setData(infos);
    }
}

