/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.sysinfo;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.sysinfo.SysInfoItem;
import com.didichuxing.doraemonkit.kit.sysinfo.SysInfoItemAdapter;
import com.didichuxing.doraemonkit.kit.sysinfo.TitleItem;
import com.didichuxing.doraemonkit.util.DeviceUtils;
import com.didichuxing.doraemonkit.util.DoKitExecutorUtil;
import com.didichuxing.doraemonkit.util.DoKitPermissionUtil;
import com.didichuxing.doraemonkit.util.DokitDeviceUtils;
import com.didichuxing.doraemonkit.util.NetworkUtils;
import com.didichuxing.doraemonkit.util.PhoneUtils;
import com.didichuxing.doraemonkit.util.UIUtils;
import com.didichuxing.doraemonkit.widget.recyclerview.DividerItemDecoration;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;
import java.util.ArrayList;
import java.util.List;

public class SysInfoFragment
extends BaseFragment {
    private RecyclerView mInfoList;
    private SysInfoItemAdapter mInfoItemAdapter;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_sys_info;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            this.initView();
            this.initData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView() {
        this.mInfoList = (RecyclerView)this.findViewById(R.id.info_list);
        HomeTitleBar titleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        titleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                SysInfoFragment.this.getActivity().finish();
            }
        });
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mInfoList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mInfoItemAdapter = new SysInfoItemAdapter(this.getContext());
        this.mInfoList.setAdapter((RecyclerView.Adapter)this.mInfoItemAdapter);
        DividerItemDecoration decoration = new DividerItemDecoration(1);
        decoration.setDrawable(this.getResources().getDrawable(R.drawable.dk_divider));
        this.mInfoList.addItemDecoration((RecyclerView.ItemDecoration)decoration);
    }

    private void initData() throws Exception {
        ArrayList<SysInfoItem> sysInfoItems = new ArrayList<SysInfoItem>();
        this.addAppData(sysInfoItems);
        this.addDeviceData(sysInfoItems);
        if (this.getContext().getApplicationInfo().targetSdkVersion >= 23) {
            this.addPermissionData(sysInfoItems);
        } else {
            this.addPermissionDataUnreliable();
        }
        this.mInfoItemAdapter.setData(sysInfoItems);
    }

    private void addAppData(List<SysInfoItem> sysInfoItems) {
        PackageInfo pi = DokitDeviceUtils.getPackageInfo(this.getContext());
        sysInfoItems.add(new TitleItem(this.getString(R.string.dk_sysinfo_app_info)));
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_package_name), pi.packageName));
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_package_version_name), pi.versionName));
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_package_version_code), String.valueOf(pi.versionCode)));
        if (Build.VERSION.SDK_INT >= 24) {
            sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_package_min_sdk), String.valueOf(this.getContext().getApplicationInfo().minSdkVersion)));
        }
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_package_target_sdk), String.valueOf(this.getContext().getApplicationInfo().targetSdkVersion)));
    }

    @SuppressLint(value={"MissingPermission"})
    private void addDeviceData(List<SysInfoItem> sysInfoItems) throws Exception {
        sysInfoItems.add(new TitleItem(this.getString(R.string.dk_sysinfo_device_info)));
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_brand_and_model), Build.MANUFACTURER + " " + Build.MODEL));
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_android_version), Build.VERSION.RELEASE + " (" + Build.VERSION.SDK_INT + ")"));
        try {
            sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_ext_storage_free), DokitDeviceUtils.getSDCardSpace(this.getContext())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_rom_free), DokitDeviceUtils.getRomSpace(this.getContext())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_display_size), UIUtils.getWidthPixels() + "x" + UIUtils.getRealHeightPixels()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_display_inch), "" + UIUtils.getScreenInch((Activity)this.getActivity())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sysInfoItems.add(new SysInfoItem("ROOT", String.valueOf(DeviceUtils.isDeviceRooted())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sysInfoItems.add(new SysInfoItem("DENSITY", String.valueOf(UIUtils.getDensity())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sysInfoItems.add(new SysInfoItem("IP", TextUtils.isEmpty((CharSequence)NetworkUtils.getIPAddress((boolean)true)) ? "null" : NetworkUtils.getIPAddress((boolean)true)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sysInfoItems.add(new SysInfoItem("Mac", TextUtils.isEmpty((CharSequence)DeviceUtils.getMacAddress()) ? "null" : DeviceUtils.getMacAddress()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sysInfoItems.add(new SysInfoItem("IMEI", TextUtils.isEmpty((CharSequence)PhoneUtils.getIMEI()) ? "null" : PhoneUtils.getIMEI()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addPermissionDataUnreliable() {
        DoKitExecutorUtil.execute(new Runnable(){

            @Override
            public void run() {
                final ArrayList<SysInfoItem> list = new ArrayList<SysInfoItem>();
                list.add(new TitleItem(SysInfoFragment.this.getString(R.string.dk_sysinfo_permission_info_unreliable)));
                list.add(new SysInfoItem(SysInfoFragment.this.getString(R.string.dk_sysinfo_permission_location), DoKitPermissionUtil.checkLocationUnreliable(SysInfoFragment.this.getContext()) ? "YES" : "NO", true));
                list.add(new SysInfoItem(SysInfoFragment.this.getString(R.string.dk_sysinfo_permission_sdcard), DoKitPermissionUtil.checkStorageUnreliable() ? "YES" : "NO", true));
                list.add(new SysInfoItem(SysInfoFragment.this.getString(R.string.dk_sysinfo_permission_camera), DoKitPermissionUtil.checkCameraUnreliable() ? "YES" : "NO", true));
                list.add(new SysInfoItem(SysInfoFragment.this.getString(R.string.dk_sysinfo_permission_record), DoKitPermissionUtil.checkRecordUnreliable() ? "YES" : "NO", true));
                list.add(new SysInfoItem(SysInfoFragment.this.getString(R.string.dk_sysinfo_permission_read_phone), DoKitPermissionUtil.checkReadPhoneUnreliable(SysInfoFragment.this.getContext()) ? "YES" : "NO", true));
                list.add(new SysInfoItem(SysInfoFragment.this.getString(R.string.dk_sysinfo_permission_contact), DoKitPermissionUtil.checkReadContactUnreliable(SysInfoFragment.this.getContext()) ? "YES" : "NO", true));
                SysInfoFragment.this.getView().post(new Runnable(){

                    @Override
                    public void run() {
                        if (SysInfoFragment.this.isDetached()) {
                            return;
                        }
                        SysInfoFragment.this.mInfoItemAdapter.append(list);
                    }
                });
            }
        });
    }

    @TargetApi(value=23)
    private void addPermissionData(List<SysInfoItem> sysInfoItems) {
        sysInfoItems.add(new TitleItem(this.getString(R.string.dk_sysinfo_permission_info)));
        String[] p1 = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_permission_location), this.checkPermission(p1), true));
        String[] p2 = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_permission_sdcard), this.checkPermission(p2), true));
        String[] p3 = new String[]{"android.permission.CAMERA"};
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_permission_camera), this.checkPermission(p3), true));
        String[] p4 = new String[]{"android.permission.RECORD_AUDIO"};
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_permission_record), this.checkPermission(p4), true));
        String[] p5 = new String[]{"android.permission.READ_PHONE_STATE"};
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_permission_read_phone), this.checkPermission(p5), true));
        String[] p6 = new String[]{"android.permission.READ_CONTACTS"};
        sysInfoItems.add(new SysInfoItem(this.getString(R.string.dk_sysinfo_permission_contact), this.checkPermission(p6), true));
    }

    private String checkPermission(String ... perms) {
        try {
            return DoKitPermissionUtil.hasPermissions(this.getContext(), perms) ? "YES" : "NO";
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return "NO";
        }
    }
}

