/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import androidx.annotation.NonNull;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.network.bean.MockApiResponseBean;
import com.didichuxing.doraemonkit.kit.network.bean.MockInterceptTitleBean;
import com.didichuxing.doraemonkit.kit.network.room_db.DokitDbManager;
import com.didichuxing.doraemonkit.kit.network.room_db.MockInterceptApiBean;
import com.didichuxing.doraemonkit.widget.brvah.entity.node.BaseNode;
import com.didichuxing.doraemonkit.widget.brvah.provider.BaseNodeProvider;
import com.didichuxing.doraemonkit.widget.brvah.viewholder.BaseViewHolder;
import java.util.List;

public class InterceptTitleNodeProvider
extends BaseNodeProvider {
    @Override
    public int getItemViewType() {
        return 100;
    }

    @Override
    public int getLayoutId() {
        return R.layout.dk_mock_title_item;
    }

    @Override
    public void convert(@NonNull BaseViewHolder holder, BaseNode item) {
        if (item instanceof MockInterceptTitleBean) {
            final MockInterceptTitleBean mockTitleBean = (MockInterceptTitleBean)item;
            MockInterceptApiBean mockApi0 = (MockInterceptApiBean)mockTitleBean.getChildNode().get(0);
            holder.setText(R.id.tv_title, mockTitleBean.getName());
            if (mockTitleBean.isExpanded()) {
                holder.setImageResource(R.id.iv_more, R.mipmap.dk_arrow_open);
            } else {
                holder.setImageResource(R.id.iv_more, R.mipmap.dk_arrow_normal);
            }
            CheckBox checkBox = (CheckBox)holder.getView(R.id.menu_switch);
            checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    List<MockApiResponseBean.DataBean.DatalistBean.SceneListBean> sceneListBeans;
                    MockInterceptApiBean mockApi = (MockInterceptApiBean)mockTitleBean.getChildNode().get(0);
                    mockApi.setOpen(isChecked);
                    if (TextUtils.isEmpty((CharSequence)mockApi.getSelectedSceneId()) && (sceneListBeans = mockApi.getSceneList()) != null && sceneListBeans.size() > 0) {
                        MockApiResponseBean.DataBean.DatalistBean.SceneListBean sceneListBean = sceneListBeans.get(0);
                        mockApi.setSelectedSceneName(sceneListBean.getName());
                        mockApi.setSelectedSceneId(sceneListBean.get_id());
                    }
                    DokitDbManager.getInstance().updateInterceptApi(mockApi);
                }
            });
            if (mockApi0.isOpen()) {
                checkBox.setChecked(true);
            } else {
                checkBox.setChecked(false);
            }
        }
    }

    @Override
    public void onClick(BaseViewHolder holder, View view, BaseNode data, int position) {
        super.onClick(holder, view, data, position);
        if (data instanceof MockInterceptTitleBean && this.getAdapter() != null) {
            this.getAdapter().expandOrCollapse(position);
            MockInterceptTitleBean mockTitleBean = (MockInterceptTitleBean)data;
            if (mockTitleBean.isExpanded()) {
                holder.setImageResource(R.id.iv_more, R.mipmap.dk_arrow_normal);
            } else {
                holder.setImageResource(R.id.iv_more, R.mipmap.dk_arrow_open);
            }
        }
    }
}

