/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.loginfo.reader;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.didichuxing.doraemonkit.kit.loginfo.helper.LogcatHelper;
import com.didichuxing.doraemonkit.kit.loginfo.reader.LogcatReader;
import com.didichuxing.doraemonkit.kit.loginfo.reader.SingleLogcatReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogcatReaderLoader
implements Parcelable {
    public static final Parcelable.Creator<LogcatReaderLoader> CREATOR = new Parcelable.Creator<LogcatReaderLoader>(){

        public LogcatReaderLoader createFromParcel(Parcel in) {
            return new LogcatReaderLoader(in);
        }

        public LogcatReaderLoader[] newArray(int size) {
            return new LogcatReaderLoader[size];
        }
    };
    private Map<String, String> lastLines = new HashMap<String, String>();
    private boolean recordingMode;
    private boolean multiple;

    private LogcatReaderLoader(Parcel in) {
        this.recordingMode = in.readInt() == 1;
        this.multiple = in.readInt() == 1;
        Bundle bundle = in.readBundle();
        for (String key : bundle.keySet()) {
            this.lastLines.put(key, bundle.getString(key));
        }
    }

    private LogcatReaderLoader(List<String> buffers, boolean recordingMode) {
        this.recordingMode = recordingMode;
        this.multiple = buffers.size() > 1;
        for (String buffer : buffers) {
            String lastLine = recordingMode ? LogcatHelper.getLastLogLine(buffer) : null;
            this.lastLines.put(buffer, lastLine);
        }
    }

    public static LogcatReaderLoader create(boolean recordingMode) {
        ArrayList<String> buffers = new ArrayList<String>();
        buffers.add("main");
        return new LogcatReaderLoader(buffers, recordingMode);
    }

    public LogcatReader loadReader() throws IOException {
        String buffer = this.lastLines.keySet().iterator().next();
        String lastLine = this.lastLines.values().iterator().next();
        SingleLogcatReader reader = new SingleLogcatReader(this.recordingMode, buffer, lastLine);
        return reader;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.recordingMode ? 1 : 0);
        dest.writeInt(this.multiple ? 1 : 0);
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : this.lastLines.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        dest.writeBundle(bundle);
    }
}

