/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.layoutborder;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;

public class ScalpelFrameLayout
extends FrameLayout {
    private static final int TRACKING_UNKNOWN = 0;
    private static final int TRACKING_VERTICALLY = 1;
    private static final int TRACKING_HORIZONTALLY = -1;
    private static final int ROTATION_MAX = 60;
    private static final int ROTATION_MIN = -60;
    private static final int ROTATION_DEFAULT_X = -10;
    private static final int ROTATION_DEFAULT_Y = 15;
    private static final float ZOOM_DEFAULT = 0.6f;
    private static final float ZOOM_MIN = 0.33f;
    private static final float ZOOM_MAX = 2.0f;
    private static final int SPACING_DEFAULT = 25;
    private static final int SPACING_MIN = 10;
    private static final int SPACING_MAX = 100;
    private static final int CHROME_COLOR = -7829368;
    private static final int CHROME_SHADOW_COLOR = -16777216;
    private static final int TEXT_OFFSET_DP = 2;
    private static final int TEXT_SIZE_DP = 10;
    private static final int CHILD_COUNT_ESTIMATION = 25;
    private static final boolean DEBUG = false;
    private final Rect viewBoundsRect = new Rect();
    private final Paint viewBorderPaint = new Paint(1);
    private final Camera camera = new Camera();
    private final Matrix matrix = new Matrix();
    private final int[] location = new int[2];
    private final BitSet visibilities = new BitSet(25);
    private final SparseArray<String> idNames = new SparseArray();
    private final Deque<LayeredView> layeredViewQueue = new ArrayDeque<LayeredView>();
    private final Pool<LayeredView> layeredViewPool = new Pool<LayeredView>(25){

        @Override
        protected LayeredView newObject() {
            return new LayeredView();
        }
    };
    private final Resources res;
    private final float density;
    private final float slop;
    private final float textOffset;
    private final float textSize;
    private boolean enabled;
    private boolean drawViews = true;
    private boolean drawIds;
    private int pointerOne = -1;
    private float lastOneX;
    private float lastOneY;
    private int pointerTwo = -1;
    private float lastTwoX;
    private float lastTwoY;
    private int multiTouchTracking = 0;
    private float rotationY = 15.0f;
    private float rotationX = -10.0f;
    private float zoom = 0.6f;
    private float spacing = 25.0f;
    private int chromeColor;
    private int chromeShadowColor;

    private static void log(String message, Object ... args) {
        Log.d((String)"Scalpel", (String)String.format(message, args));
    }

    public ScalpelFrameLayout(Context context) {
        this(context, null);
    }

    public ScalpelFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScalpelFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.res = context.getResources();
        this.density = context.getResources().getDisplayMetrics().density;
        this.slop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.textSize = 10.0f * this.density;
        this.textOffset = 2.0f * this.density;
        this.setChromeColor(-7829368);
        this.viewBorderPaint.setStyle(Paint.Style.STROKE);
        this.viewBorderPaint.setTextSize(this.textSize);
        this.setChromeShadowColor(-16777216);
        if (Build.VERSION.SDK_INT >= 16) {
            this.viewBorderPaint.setTypeface(Typeface.create((String)"sans-serif-condensed", (int)0));
        }
    }

    public void setChromeColor(int color2) {
        if (this.chromeColor != color2) {
            this.viewBorderPaint.setColor(color2);
            this.chromeColor = color2;
            this.invalidate();
        }
    }

    public int getChromeColor() {
        return this.chromeColor;
    }

    public void setChromeShadowColor(int color2) {
        if (this.chromeShadowColor != color2) {
            this.viewBorderPaint.setShadowLayer(1.0f, -1.0f, 1.0f, color2);
            this.chromeShadowColor = color2;
            this.invalidate();
        }
    }

    public int getChromeShadowColor() {
        return this.chromeShadowColor;
    }

    public void setLayerInteractionEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.setWillNotDraw(!enabled);
            this.invalidate();
        }
    }

    public boolean isLayerInteractionEnabled() {
        return this.enabled;
    }

    public void setDrawViews(boolean drawViews) {
        if (this.drawViews != drawViews) {
            this.drawViews = drawViews;
            this.invalidate();
        }
    }

    public boolean isDrawingViews() {
        return this.drawViews;
    }

    public void setDrawIds(boolean drawIds) {
        if (this.drawIds != drawIds) {
            this.drawIds = drawIds;
            this.invalidate();
        }
    }

    public boolean isDrawingIds() {
        return this.drawIds;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.enabled || super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.enabled) {
            return super.onTouchEvent(event);
        }
        int action = event.getActionMasked();
        switch (action) {
            case 0: 
            case 5: {
                int index;
                int n = index = action == 0 ? 0 : event.getActionIndex();
                if (this.pointerOne == -1) {
                    this.pointerOne = event.getPointerId(index);
                    this.lastOneX = event.getX(index);
                    this.lastOneY = event.getY(index);
                    break;
                }
                if (this.pointerTwo != -1) break;
                this.pointerTwo = event.getPointerId(index);
                this.lastTwoX = event.getX(index);
                this.lastTwoY = event.getY(index);
                break;
            }
            case 2: {
                if (this.pointerTwo == -1) {
                    int count = event.getPointerCount();
                    for (int i = 0; i < count; ++i) {
                        if (this.pointerOne != event.getPointerId(i)) continue;
                        float eventX = event.getX(i);
                        float eventY = event.getY(i);
                        float dx = eventX - this.lastOneX;
                        float dy = eventY - this.lastOneY;
                        float drx = 90.0f * (dx / (float)this.getWidth());
                        float dry = 90.0f * (-dy / (float)this.getHeight());
                        this.rotationY = Math.min(Math.max(this.rotationY + drx, -60.0f), 60.0f);
                        this.rotationX = Math.min(Math.max(this.rotationX + dry, -60.0f), 60.0f);
                        this.lastOneX = eventX;
                        this.lastOneY = eventY;
                        this.invalidate();
                    }
                    break;
                }
                int pointerOneIndex = event.findPointerIndex(this.pointerOne);
                int pointerTwoIndex = event.findPointerIndex(this.pointerTwo);
                float xOne = event.getX(pointerOneIndex);
                float yOne = event.getY(pointerOneIndex);
                float xTwo = event.getX(pointerTwoIndex);
                float yTwo = event.getY(pointerTwoIndex);
                float dxOne = xOne - this.lastOneX;
                float dyOne = yOne - this.lastOneY;
                float dxTwo = xTwo - this.lastTwoX;
                float dyTwo = yTwo - this.lastTwoY;
                if (this.multiTouchTracking == 0) {
                    float adx = Math.abs(dxOne) + Math.abs(dxTwo);
                    float ady = Math.abs(dyOne) + Math.abs(dyTwo);
                    if (adx > this.slop * 2.0f || ady > this.slop * 2.0f) {
                        this.multiTouchTracking = adx > ady ? -1 : 1;
                    }
                }
                if (this.multiTouchTracking == 1) {
                    this.zoom = yOne >= yTwo ? (this.zoom += dyOne / (float)this.getHeight() - dyTwo / (float)this.getHeight()) : (this.zoom += dyTwo / (float)this.getHeight() - dyOne / (float)this.getHeight());
                    this.zoom = Math.min(Math.max(this.zoom, 0.33f), 2.0f);
                    this.invalidate();
                } else if (this.multiTouchTracking == -1) {
                    this.spacing = xOne >= xTwo ? (this.spacing += dxOne / (float)this.getWidth() * 100.0f - dxTwo / (float)this.getWidth() * 100.0f) : (this.spacing += dxTwo / (float)this.getWidth() * 100.0f - dxOne / (float)this.getWidth() * 100.0f);
                    this.spacing = Math.min(Math.max(this.spacing, 10.0f), 100.0f);
                    this.invalidate();
                }
                if (this.multiTouchTracking == 0) break;
                this.lastOneX = xOne;
                this.lastOneY = yOne;
                this.lastTwoX = xTwo;
                this.lastTwoY = yTwo;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                int index = action != 6 ? 0 : event.getActionIndex();
                int pointerId = event.getPointerId(index);
                if (this.pointerOne == pointerId) {
                    this.pointerOne = this.pointerTwo;
                    this.lastOneX = this.lastTwoX;
                    this.lastOneY = this.lastTwoY;
                    this.pointerTwo = -1;
                    this.multiTouchTracking = 0;
                    break;
                }
                if (this.pointerTwo != pointerId) break;
                this.pointerTwo = -1;
                this.multiTouchTracking = 0;
                break;
            }
        }
        return true;
    }

    public void draw(Canvas canvas) {
        if (!this.enabled) {
            super.draw(canvas);
            return;
        }
        this.getLocationInWindow(this.location);
        float x = this.location[0];
        float y = this.location[1];
        int saveCount = canvas.save();
        float cx = (float)this.getWidth() / 2.0f;
        float cy = (float)this.getHeight() / 2.0f;
        this.camera.save();
        this.camera.rotate(this.rotationX, this.rotationY, 0.0f);
        this.camera.getMatrix(this.matrix);
        this.camera.restore();
        this.matrix.preTranslate(-cx, -cy);
        this.matrix.postTranslate(cx, cy);
        canvas.concat(this.matrix);
        canvas.scale(this.zoom, this.zoom, cx, cy);
        if (!this.layeredViewQueue.isEmpty()) {
            throw new AssertionError((Object)"View queue is not empty.");
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            LayeredView layeredView = this.layeredViewPool.obtain();
            layeredView.set(this.getChildAt(i), 0);
            this.layeredViewQueue.add(layeredView);
        }
        while (!this.layeredViewQueue.isEmpty()) {
            int id2;
            LayeredView layeredView = this.layeredViewQueue.removeFirst();
            View view = layeredView.view;
            int layer = layeredView.layer;
            layeredView.clear();
            this.layeredViewPool.restore(layeredView);
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                this.visibilities.clear();
                int count2 = viewGroup.getChildCount();
                for (int i = 0; i < count2; ++i) {
                    View child = viewGroup.getChildAt(i);
                    if (child.getVisibility() != 0) continue;
                    this.visibilities.set(i);
                    child.setVisibility(4);
                }
            }
            int viewSaveCount = canvas.save();
            float translateShowX = this.rotationY / 60.0f;
            float translateShowY = this.rotationX / 60.0f;
            float tx = (float)layer * this.spacing * this.density * translateShowX;
            float ty = (float)layer * this.spacing * this.density * translateShowY;
            canvas.translate(tx, -ty);
            view.getLocationInWindow(this.location);
            canvas.translate((float)this.location[0] - x, (float)this.location[1] - y);
            this.viewBoundsRect.set(0, 0, view.getWidth(), view.getHeight());
            canvas.drawRect(this.viewBoundsRect, this.viewBorderPaint);
            if (this.drawViews && !(view instanceof SurfaceView)) {
                view.draw(canvas);
            }
            if (this.drawIds && (id2 = view.getId()) != -1) {
                canvas.drawText(this.nameForId(id2), this.textOffset, this.textSize, this.viewBorderPaint);
            }
            canvas.restoreToCount(viewSaveCount);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            int count3 = viewGroup.getChildCount();
            for (int i = 0; i < count3; ++i) {
                if (!this.visibilities.get(i)) continue;
                View child = viewGroup.getChildAt(i);
                child.setVisibility(0);
                LayeredView childLayeredView = this.layeredViewPool.obtain();
                childLayeredView.set(child, layer + 1);
                this.layeredViewQueue.add(childLayeredView);
            }
        }
        canvas.restoreToCount(saveCount);
    }

    private String nameForId(int id2) {
        String name = (String)this.idNames.get(id2);
        if (name == null) {
            try {
                name = this.res.getResourceEntryName(id2);
            }
            catch (Resources.NotFoundException e) {
                name = String.format("0x%8x", id2);
            }
            this.idNames.put(id2, (Object)name);
        }
        return name;
    }

    private static abstract class Pool<T> {
        private final Deque<T> pool;

        Pool(int initialSize) {
            this.pool = new ArrayDeque<T>(initialSize);
            for (int i = 0; i < initialSize; ++i) {
                this.pool.addLast(this.newObject());
            }
        }

        T obtain() {
            return this.pool.isEmpty() ? this.newObject() : this.pool.removeLast();
        }

        void restore(T instance) {
            this.pool.addLast(instance);
        }

        protected abstract T newObject();
    }

    private static class LayeredView {
        View view;
        int layer;

        private LayeredView() {
        }

        void set(View view, int layer) {
            this.view = view;
            this.layer = layer;
        }

        void clear() {
            this.view = null;
            this.layer = -1;
        }
    }
}

