/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.gpsmock;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.IBinder;
import com.didichuxing.doraemonkit.kit.gpsmock.BaseServiceHooker;
import com.didichuxing.doraemonkit.kit.gpsmock.GpsMockManager;
import com.didichuxing.doraemonkit.kit.gpsmock.MethodHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WifiHooker
extends BaseServiceHooker {
    @Override
    public String serviceName() {
        return "wifi";
    }

    @Override
    public String stubName() {
        return "android.net.wifi.IWifiManager$Stub";
    }

    @Override
    public Map<String, MethodHandler> registerMethodHandlers() {
        HashMap<String, MethodHandler> methodHandlers = new HashMap<String, MethodHandler>();
        methodHandlers.put("getScanResults", new GetScanResultsMethodHandler());
        methodHandlers.put("getConnectionInfo", new GetConnectionInfoMethodHandler());
        return methodHandlers;
    }

    @Override
    public void replaceBinderProxy(Context context, IBinder proxy) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wifiManager == null) {
            return;
        }
        Class<?> wifiManagerClass = wifiManager.getClass();
        Field mServiceField = wifiManagerClass.getDeclaredField("mService");
        mServiceField.setAccessible(true);
        Class<?> stub = Class.forName(this.stubName());
        Method asInterface = stub.getDeclaredMethod("asInterface", IBinder.class);
        mServiceField.set(wifiManager, asInterface.invoke(null, proxy));
        mServiceField.setAccessible(false);
    }

    static class GetConnectionInfoMethodHandler
    extends MethodHandler {
        GetConnectionInfoMethodHandler() {
        }

        @Override
        public Object onInvoke(Object originObject, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if (!GpsMockManager.getInstance().isMocking()) {
                return method.invoke(originObject, args);
            }
            try {
                return Class.forName("android.net.wifi.WifiInfo").newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return method.invoke(originObject, args);
        }
    }

    static class GetScanResultsMethodHandler
    extends MethodHandler {
        GetScanResultsMethodHandler() {
        }

        @Override
        public Object onInvoke(Object originService, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if (!GpsMockManager.getInstance().isMocking()) {
                return method.invoke(originService, args);
            }
            return new ArrayList();
        }
    }
}

