/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.fileexplorer;

import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.fileexplorer.TextContentAdapter;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class TextDetailFragment
extends BaseFragment {
    private static final String TAG = "TextDetailFragment";
    private RecyclerView mContent;
    private TextContentAdapter mContentAdapter;
    private File mFile;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        TitleBar titleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
        titleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

            @Override
            public void onLeftClick() {
                TextDetailFragment.this.finish();
            }

            @Override
            public void onRightClick() {
            }
        });
        this.initContent();
        Bundle data = this.getArguments();
        if (data != null) {
            this.mFile = (File)data.getSerializable("file_key");
        }
        this.readFile(this.mFile);
    }

    public void initContent() {
        this.mContent = (RecyclerView)this.findViewById(R.id.text_list);
        this.mContent.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mContentAdapter = new TextContentAdapter(this.getContext());
        this.mContent.setAdapter((RecyclerView.Adapter)this.mContentAdapter);
    }

    private void readFile(File file) {
        if (this.mFile == null) {
            return;
        }
        FileReadTask task = new FileReadTask(this);
        task.execute(new File[]{file});
    }

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_text_detail;
    }

    private static class FileReadTask
    extends AsyncTask<File, String, Void> {
        private WeakReference<TextDetailFragment> mReference;

        public FileReadTask(TextDetailFragment fragment) {
            this.mReference = new WeakReference<TextDetailFragment>(fragment);
        }

        protected Void doInBackground(File ... files) {
            try {
                String textLine;
                FileReader fileReader = new FileReader(files[0]);
                BufferedReader br = new BufferedReader(fileReader);
                while ((textLine = br.readLine()) != null) {
                    this.publishProgress(new String[]{textLine});
                }
                br.close();
                fileReader.close();
            }
            catch (IOException e) {
                LogHelper.e(TextDetailFragment.TAG, e.toString());
            }
            return null;
        }

        protected void onProgressUpdate(String ... values) {
            super.onProgressUpdate((Object[])values);
            if (this.mReference.get() != null) {
                ((TextDetailFragment)((Object)this.mReference.get())).mContentAdapter.append(values[0]);
            }
        }
    }
}

