/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.fileexplorer;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.fileexplorer.DatabaseDetailFragment;
import com.didichuxing.doraemonkit.kit.fileexplorer.FileExplorerChooseDialog;
import com.didichuxing.doraemonkit.kit.fileexplorer.FileInfo;
import com.didichuxing.doraemonkit.kit.fileexplorer.FileInfoAdapter;
import com.didichuxing.doraemonkit.kit.fileexplorer.ImageDetailFragment;
import com.didichuxing.doraemonkit.kit.fileexplorer.SpFragment;
import com.didichuxing.doraemonkit.kit.fileexplorer.TextDetailFragment;
import com.didichuxing.doraemonkit.kit.fileexplorer.VideoPlayFragment;
import com.didichuxing.doraemonkit.util.DoKitFileUtil;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FileExplorerFragment
extends BaseFragment {
    private static final String TAG = "FileExplorerFragment";
    private FileInfoAdapter mFileInfoAdapter;
    private RecyclerView mFileList;
    private TitleBar mTitleBar;
    private File mCurDir;

    private void initFileInfoList() {
        this.mTitleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
        this.mTitleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

            @Override
            public void onLeftClick() {
                FileExplorerFragment.this.onBackPressed();
            }

            @Override
            public void onRightClick() {
            }
        });
        this.mFileList = (RecyclerView)this.findViewById(R.id.file_list);
        this.mFileList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mFileInfoAdapter = new FileInfoAdapter(this.getContext());
        this.mFileInfoAdapter.setOnViewClickListener(new FileInfoAdapter.OnViewClickListener(){

            @Override
            public void onViewClick(View v, FileInfo fileInfo) {
                if (fileInfo.file.isFile()) {
                    Bundle bundle = new Bundle();
                    bundle.putSerializable("file_key", (Serializable)fileInfo.file);
                    if (DoKitFileUtil.isImage(fileInfo.file)) {
                        FileExplorerFragment.this.showContent(ImageDetailFragment.class, bundle);
                    } else if (DoKitFileUtil.isDB(fileInfo.file)) {
                        FileExplorerFragment.this.showContent(DatabaseDetailFragment.class, bundle);
                    } else if (DoKitFileUtil.isVideo(fileInfo.file)) {
                        FileExplorerFragment.this.showContent(VideoPlayFragment.class, bundle);
                    } else if (DoKitFileUtil.isSp(fileInfo.file)) {
                        FileExplorerFragment.this.showContent(SpFragment.class, bundle);
                    } else {
                        FileExplorerFragment.this.showContent(TextDetailFragment.class, bundle);
                    }
                } else {
                    FileExplorerFragment.this.mCurDir = fileInfo.file;
                    FileExplorerFragment.this.mTitleBar.setTitle(FileExplorerFragment.this.mCurDir.getName());
                    FileExplorerFragment.this.setAdapterData(FileExplorerFragment.this.getFileInfos(FileExplorerFragment.this.mCurDir));
                }
            }
        });
        this.mFileInfoAdapter.setOnViewLongClickListener(new FileInfoAdapter.OnViewLongClickListener(){

            @Override
            public boolean onViewLongClick(View v, final FileInfo fileInfo) {
                FileExplorerChooseDialog dialog = new FileExplorerChooseDialog(fileInfo.file, null);
                dialog.setOnButtonClickListener(new FileExplorerChooseDialog.OnButtonClickListener(){

                    @Override
                    public void onDeleteClick(FileExplorerChooseDialog dialog) {
                        DoKitFileUtil.deleteDirectory(fileInfo.file);
                        dialog.dismiss();
                        if (FileExplorerFragment.this.mCurDir != null) {
                            FileExplorerFragment.this.mTitleBar.setTitle(FileExplorerFragment.this.mCurDir.getName());
                            FileExplorerFragment.this.setAdapterData(FileExplorerFragment.this.getFileInfos(FileExplorerFragment.this.mCurDir));
                        }
                    }

                    @Override
                    public void onShareClick(FileExplorerChooseDialog dialog) {
                        DoKitFileUtil.systemShare(FileExplorerFragment.this.getContext(), fileInfo.file);
                        dialog.dismiss();
                    }
                });
                FileExplorerFragment.this.showDialog(dialog);
                return true;
            }
        });
        this.setAdapterData(this.initRootFileInfos(this.getContext()));
        this.mFileList.setAdapter((RecyclerView.Adapter)this.mFileInfoAdapter);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mCurDir = null;
        this.initFileInfoList();
    }

    private List<FileInfo> getFileInfos(File dir) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        if (dir.listFiles() == null) {
            return fileInfos;
        }
        for (File file : dir.listFiles()) {
            FileInfo fileInfo = new FileInfo(file);
            fileInfos.add(fileInfo);
        }
        return fileInfos;
    }

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_file_explorer;
    }

    @Override
    public boolean onBackPressed() {
        if (this.mCurDir == null) {
            this.finish();
            return true;
        }
        if (this.isRootFile(this.getContext(), this.mCurDir)) {
            this.mTitleBar.setTitle(R.string.dk_kit_file_explorer);
            this.setAdapterData(this.initRootFileInfos(this.getContext()));
            this.mCurDir = null;
            return true;
        }
        this.mCurDir = this.mCurDir.getParentFile();
        this.mTitleBar.setTitle(this.mCurDir.getName());
        List<FileInfo> fileInfos = this.getFileInfos(this.mCurDir);
        this.setAdapterData(fileInfos);
        return true;
    }

    private void setAdapterData(List<FileInfo> fileInfos) {
        if (fileInfos.isEmpty()) {
            this.mFileInfoAdapter.clear();
        } else {
            this.mFileInfoAdapter.setData(fileInfos);
        }
    }

    private List<FileInfo> initRootFileInfos(Context context) {
        List<File> rootFiles = this.getRootFiles();
        if (rootFiles != null) {
            ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
            for (File file : rootFiles) {
                fileInfos.add(new FileInfo(file));
            }
            return fileInfos;
        }
        return this.initDefaultRootFileInfos(context);
    }

    private List<File> getRootFiles() {
        File dir;
        if (this.getArguments() != null && (dir = (File)this.getArguments().getSerializable("dir_key")) != null && dir.exists()) {
            return Arrays.asList(dir.listFiles());
        }
        return null;
    }

    private List<FileInfo> initDefaultRootFileInfos(Context context) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        fileInfos.add(new FileInfo(context.getFilesDir().getParentFile()));
        fileInfos.add(new FileInfo(context.getExternalCacheDir()));
        fileInfos.add(new FileInfo(context.getExternalFilesDir(null)));
        return fileInfos;
    }

    private boolean isRootFile(Context context, File file) {
        Iterator<File> iterator;
        if (file == null) {
            return false;
        }
        List<File> rootFiles = this.getRootFiles();
        if (rootFiles != null && (iterator = rootFiles.iterator()).hasNext()) {
            File rootFile = iterator.next();
            return file.equals(rootFile);
        }
        return file.equals(context.getExternalCacheDir()) || file.equals(context.getExternalFilesDir(null)) || file.equals(context.getFilesDir().getParentFile());
    }
}

