/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.colorpick;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.RequiresApi;
import com.didichuxing.doraemonkit.DoKitEnv;
import com.didichuxing.doraemonkit.kit.colorpick.ColorPickManager;
import com.didichuxing.doraemonkit.kit.colorpick.ColorPickerDokitView;
import com.didichuxing.doraemonkit.kit.colorpick.ScreenRecorderService;
import com.didichuxing.doraemonkit.util.AppUtils;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.UIUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class ImageCapture {
    private static final String TAG = "ImageCapture";
    private MediaProjectionManager mMediaProjectionManager;
    private MediaProjection mMediaProjection;
    private ImageReader mImageReader;
    private boolean isCapturing;
    private Bitmap mBitmap;
    private ColorPickerDokitView mColorPickerDokitView;

    public void init(Context context, Bundle bundle, ColorPickerDokitView colorPickerDokitView) throws Exception {
        this.mColorPickerDokitView = colorPickerDokitView;
        PackageManager packageManager = DoKitEnv.requireApp().getPackageManager();
        ApplicationInfo applicationInfo = packageManager.getApplicationInfo(AppUtils.getAppPackageName(), 0);
        if (applicationInfo.targetSdkVersion >= 29) {
            if (ColorPickManager.getInstance().getMediaProjection() != null) {
                colorPickerDokitView.onScreenServiceReady();
            } else {
                try {
                    if (Build.VERSION.SDK_INT >= 26 && bundle.getParcelable("data") instanceof Intent) {
                        Intent dataIntent = (Intent)bundle.getParcelable("data");
                        Intent intent = new Intent(context, ScreenRecorderService.class);
                        intent.putExtra("data", (Parcelable)dataIntent);
                        context.startForegroundService(intent);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.mMediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
            if (this.mMediaProjectionManager != null) {
                this.mMediaProjection = this.mMediaProjectionManager.getMediaProjection(-1, (Intent)bundle.getParcelable("data"));
                this.initImageRead(this.mMediaProjection);
            }
        }
    }

    @SuppressLint(value={"WrongConstant"})
    void initImageRead(MediaProjection mediaProjection) {
        if (mediaProjection == null) {
            LogHelper.e(TAG, "mediaProjection == null");
            return;
        }
        int width = UIUtils.getWidthPixels();
        int height = UIUtils.getRealHeightPixels();
        int dpi = UIUtils.getDensityDpi();
        this.mImageReader = ImageReader.newInstance((int)width, (int)height, (int)1, (int)2);
        mediaProjection.createVirtualDisplay("ScreenCapture", width, height, dpi, 16, this.mImageReader.getSurface(), null, null);
    }

    void capture() {
        if (this.isCapturing) {
            return;
        }
        if (this.mImageReader == null) {
            return;
        }
        this.isCapturing = true;
        Image image = this.mImageReader.acquireLatestImage();
        if (image == null) {
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        Image.Plane[] planes = image.getPlanes();
        ByteBuffer buffer = planes[0].getBuffer();
        int pixelStride = planes[0].getPixelStride();
        int rowStride = planes[0].getRowStride();
        int rowPaddingStride = rowStride - pixelStride * width;
        int rowPadding = rowPaddingStride / pixelStride;
        Bitmap recordBitmap = Bitmap.createBitmap((int)(width + rowPadding), (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        recordBitmap.copyPixelsFromBuffer((Buffer)buffer);
        this.mBitmap = Bitmap.createBitmap((Bitmap)recordBitmap, (int)0, (int)0, (int)width, (int)height);
        image.close();
        this.isCapturing = false;
    }

    Bitmap getPartBitmap(int x, int y, int width, int height) {
        if (this.mBitmap == null) {
            return null;
        }
        if (x < 0) {
            x = 0;
        }
        if (x + width > this.mBitmap.getWidth()) {
            x = this.mBitmap.getWidth() - width;
        }
        if (y < 0) {
            y = 0;
        }
        if (y + height > this.mBitmap.getHeight()) {
            y = this.mBitmap.getHeight() - height;
        }
        return Bitmap.createBitmap((Bitmap)this.mBitmap, (int)x, (int)y, (int)width, (int)height);
    }

    void destroy() {
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
        if (this.mMediaProjection != null) {
            this.mMediaProjection.stop();
            this.mMediaProjection = null;
        }
        this.mMediaProjectionManager = null;
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }
}

