/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.colorpick;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.RequiresApi;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.colorpick.ColorPickManager;
import com.didichuxing.doraemonkit.kit.colorpick.ColorPickerInfoDokitView;
import com.didichuxing.doraemonkit.kit.colorpick.ColorPickerView;
import com.didichuxing.doraemonkit.kit.colorpick.ImageCapture;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.DoKitImageUtil;
import com.didichuxing.doraemonkit.util.UIUtils;

@RequiresApi(api=21)
public class ColorPickerDokitView
extends AbsDokitView {
    private ImageCapture mImageCapture;
    private ColorPickerView mPickerView;
    private ColorPickerInfoDokitView mInfoDokitView;
    private int width;
    private int height;
    private int statusBarHeight;
    private Runnable mRunnable;

    @Override
    public void onCreate(Context context) {
        ColorPickManager.getInstance().setColorPickerDokitView(this);
        this.mInfoDokitView = DoKit.getDoKitView(ActivityUtils.getTopActivity(), ColorPickerInfoDokitView.class);
        this.mImageCapture = new ImageCapture();
        try {
            this.mImageCapture.init(context, this.getBundle(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void onScreenServiceReady() {
        this.mImageCapture.initImageRead(ColorPickManager.getInstance().getMediaProjection());
    }

    @Override
    public void onViewCreated(FrameLayout view) {
        this.initView();
    }

    private void initView() {
        this.mPickerView = (ColorPickerView)((Object)this.findViewById(R.id.picker_view));
        ViewGroup.LayoutParams params = this.mPickerView.getLayoutParams();
        params.width = 512;
        params.height = 512;
        this.mPickerView.setLayoutParams(params);
        this.width = UIUtils.getWidthPixels();
        this.height = UIUtils.getHeightPixels();
        this.statusBarHeight = UIUtils.getStatusBarHeight();
        this.captureInfo(500);
    }

    @Override
    public View onCreateView(Context context, FrameLayout view) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_float_color_picker, null);
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.flags = 520;
        params.height = DokitViewLayoutParams.WRAP_CONTENT;
        params.width = DokitViewLayoutParams.WRAP_CONTENT;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mImageCapture.destroy();
    }

    private void showInfo() {
        int y;
        int x;
        if (this.isNormalMode()) {
            x = this.getNormalLayoutParams().leftMargin;
            y = this.getNormalLayoutParams().topMargin;
        } else {
            x = this.getSystemLayoutParams().x;
            y = this.getSystemLayoutParams().y;
        }
        int pickAreaSize = 32;
        int startX = x + 256 - pickAreaSize / 2;
        int startY = y + 256 - pickAreaSize / 2 + UIUtils.getStatusBarHeight();
        Bitmap bitmap = this.mImageCapture.getPartBitmap(startX, startY, pickAreaSize, pickAreaSize);
        if (bitmap == null) {
            return;
        }
        int xCenter = bitmap.getWidth() / 2;
        int yCenter = bitmap.getHeight() / 2;
        int colorInt = DoKitImageUtil.getPixel(bitmap, xCenter, yCenter);
        this.mPickerView.setBitmap(bitmap, colorInt, startX, startY);
        this.mInfoDokitView.showInfo(colorInt, startX, startY);
    }

    private void captureInfo(int delay) {
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                ColorPickerDokitView.this.mImageCapture.capture();
                ColorPickerDokitView.this.mPickerView.setVisibility(0);
                ColorPickerDokitView.this.showInfo();
            }
        };
        this.mPickerView.setVisibility(4);
        this.getDoKitView().postDelayed(this.mRunnable, (long)delay);
    }

    @Override
    public void onDown(int x, int y) {
        super.onDown(x, y);
        this.captureInfo(100);
    }

    @Override
    public void onMove(int x, int y, int dx, int dy) {
        super.onMove(x, y, dx, dy);
        if (this.isNormalMode() && this.getNormalLayoutParams() != null) {
            this.checkBound(this.getNormalLayoutParams());
        } else if (this.getSystemLayoutParams() != null) {
            this.checkBound(this.getSystemLayoutParams());
        }
        this.showInfo();
    }

    private void checkBound(FrameLayout.LayoutParams layoutParams) {
        if (layoutParams.leftMargin < -this.mPickerView.getWidth() / 2) {
            layoutParams.leftMargin = -this.mPickerView.getWidth() / 2;
        }
        if (layoutParams.leftMargin > this.width - this.mPickerView.getWidth() / 2 - 16) {
            layoutParams.leftMargin = this.width - this.mPickerView.getWidth() / 2 - 16;
        }
        if (layoutParams.topMargin < -this.mPickerView.getHeight() / 2 - this.statusBarHeight) {
            layoutParams.topMargin = -this.mPickerView.getHeight() / 2 - this.statusBarHeight;
        }
        if (layoutParams.topMargin > this.height - this.mPickerView.getHeight() / 2 - 16) {
            layoutParams.topMargin = this.height - this.mPickerView.getHeight() / 2 - 16;
        }
        layoutParams.width = 512;
        layoutParams.height = 512;
        this.immInvalidate();
    }

    private void checkBound(WindowManager.LayoutParams layoutParams) {
        if (layoutParams.x < -this.mPickerView.getWidth() / 2) {
            layoutParams.x = -this.mPickerView.getWidth() / 2;
        }
        if (layoutParams.x > this.width - this.mPickerView.getWidth() / 2 - 16) {
            layoutParams.x = this.width - this.mPickerView.getWidth() / 2 - 16;
        }
        if (layoutParams.y < -this.mPickerView.getHeight() / 2 - this.statusBarHeight) {
            layoutParams.y = -this.mPickerView.getHeight() / 2 - this.statusBarHeight;
        }
        if (layoutParams.y > this.height - this.mPickerView.getHeight() / 2 - 16) {
            layoutParams.y = this.height - this.mPickerView.getHeight() / 2 - 16;
        }
    }

    @Override
    public void onEnterBackground() {
        if (DoKitManager.IS_NORMAL_FLOAT_MODE) {
            this.getDoKitView().removeCallbacks(this.mRunnable);
        }
    }

    @Override
    public void onEnterForeground() {
    }

    @Override
    public boolean restrictBorderline() {
        return false;
    }
}

