/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.alignruler;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.AlignRulerConfig;
import com.didichuxing.doraemonkit.kit.alignruler.AlignRulerLineDokitView;
import com.didichuxing.doraemonkit.kit.alignruler.AlignRulerMarkerDokitView;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.core.SettingItemAdapter;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;

public class AlignRulerSettingFragment
extends BaseFragment {
    private HomeTitleBar mTitleBar;
    private RecyclerView mSettingList;
    private SettingItemAdapter mSettingItemAdapter;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initTitleBar();
    }

    private void initTitleBar() {
        this.mTitleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        this.mTitleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                AlignRulerSettingFragment.this.finish();
            }
        });
        this.mSettingList = (RecyclerView)this.findViewById(R.id.setting_list);
        this.mSettingList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mSettingItemAdapter = new SettingItemAdapter(this.getContext());
        this.mSettingItemAdapter.append(new SettingItem(R.string.dk_kit_align_ruler, AlignRulerConfig.isAlignRulerOpen()));
        this.mSettingList.setAdapter((RecyclerView.Adapter)this.mSettingItemAdapter);
        this.mSettingItemAdapter.setOnSettingItemSwitchListener(new SettingItemAdapter.OnSettingItemSwitchListener(){

            @Override
            public void onSettingItemSwitch(View view, SettingItem data, boolean on) {
                if (data.desc == R.string.dk_kit_align_ruler) {
                    if (on) {
                        DoKit.launchFloating(AlignRulerMarkerDokitView.class);
                        DoKit.launchFloating(AlignRulerLineDokitView.class);
                    } else {
                        DoKit.removeFloating(AlignRulerMarkerDokitView.class);
                        DoKit.removeFloating(AlignRulerLineDokitView.class);
                    }
                    AlignRulerConfig.setAlignRulerOpen(on);
                }
            }
        });
    }

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_align_ruler_setting;
    }
}

