/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.alignruler;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.AlignRulerConfig;
import com.didichuxing.doraemonkit.kit.alignruler.AlignRulerLineDokitView;
import com.didichuxing.doraemonkit.kit.alignruler.AlignRulerMarkerDokitView;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.UIUtils;

public class AlignRulerInfoDokitView
extends AbsDokitView
implements AlignRulerMarkerDokitView.OnAlignRulerMarkerPositionChangeListener {
    private TextView mAlignHex;
    private ImageView mClose;
    private AlignRulerMarkerDokitView mMarker;
    private int mWindowWidth;
    private int mWindowHeight;
    private CheckBox mIncludeStatusBarHeight;
    private OnCheckedChangeListener mListener;
    private int left;
    private int right;
    private int top;
    private int bottom;

    @Override
    public void onCreate(Context context) {
        this.mWindowWidth = UIUtils.getWidthPixels();
        this.mWindowHeight = UIUtils.getHeightPixels();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mMarker.removePositionChangeListener(this);
    }

    @Override
    public View onCreateView(Context context, FrameLayout view) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_float_align_ruler_info, null);
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.width = this.getScreenShortSideLength();
        params.height = -2;
        params.x = 0;
        params.y = UIUtils.getHeightPixels() - UIUtils.dp2px(150.0f);
    }

    @Override
    public void onViewCreated(FrameLayout view) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                AlignRulerInfoDokitView.this.mMarker = DoKit.getDoKitView(ActivityUtils.getTopActivity(), AlignRulerMarkerDokitView.class);
                if (AlignRulerInfoDokitView.this.mMarker != null) {
                    AlignRulerInfoDokitView.this.mMarker.addPositionChangeListener(AlignRulerInfoDokitView.this);
                }
            }
        }, 100L);
        this.initView();
    }

    private void initView() {
        this.getDoKitView().setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return AlignRulerInfoDokitView.this.mTouchProxy.onTouchEvent(v, event);
            }
        });
        this.mAlignHex = (TextView)this.findViewById(R.id.align_hex);
        this.mClose = (ImageView)this.findViewById(R.id.close);
        this.mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlignRulerConfig.setAlignRulerOpen(false);
                DoKit.removeFloating(AlignRulerMarkerDokitView.class);
                DoKit.removeFloating(AlignRulerLineDokitView.class);
                DoKit.removeFloating(AlignRulerInfoDokitView.class);
            }
        });
        this.mIncludeStatusBarHeight = (CheckBox)this.findViewById(R.id.cb_status_bar);
        this.mIncludeStatusBarHeight.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (AlignRulerInfoDokitView.this.mListener != null) {
                    AlignRulerInfoDokitView.this.mListener.onCheckedChanged(isChecked);
                }
                AlignRulerInfoDokitView.this.setTextInfo(isChecked);
            }
        });
    }

    public void setCheckBoxListener(OnCheckedChangeListener mListener) {
        this.mListener = mListener;
    }

    @Override
    public void onPositionChanged(int x, int y) {
        this.left = x;
        this.top = y;
        this.right = this.mWindowWidth - this.left;
        this.bottom = this.mWindowHeight - this.top;
        this.setTextInfo(this.mIncludeStatusBarHeight.isChecked());
    }

    private void setTextInfo(boolean includeStatusBar) {
        if (includeStatusBar) {
            this.mAlignHex.setText((CharSequence)this.getResources().getString(R.string.dk_align_info_text, new Object[]{this.left, this.right, this.top + UIUtils.getStatusBarHeight(), this.bottom}));
        } else {
            this.mAlignHex.setText((CharSequence)this.getResources().getString(R.string.dk_align_info_text, new Object[]{this.left, this.right, this.top, this.bottom}));
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(boolean var1);
    }
}

