/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.aop;

import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.constant.DoKitModule;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.core.DokitAbility;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.AbsDoKitInterceptor;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.DokitCapInterceptor;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.DokitExtInterceptor;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.DokitLargePicInterceptor;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.DokitMockInterceptor;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.DokitWeakNetworkInterceptor;
import com.didichuxing.doraemonkit.util.ReflectUtils;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpHook {
    public static void addDoKitIntercept(OkHttpClient client) {
        if (!DoKit.isInit()) {
            return;
        }
        try {
            Object interceptor;
            ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(client.interceptors());
            ArrayList<Interceptor> networkInterceptors = new ArrayList<Interceptor>(client.networkInterceptors());
            DokitAbility.DokitModuleProcessor processor = DoKitManager.INSTANCE.getModuleProcessor(DoKitModule.MODULE_MC);
            if (processor != null && (interceptor = processor.values().get("okhttp_interceptor")) instanceof AbsDoKitInterceptor) {
                OkHttpHook.noDuplicateAdd(interceptors, (AbsDoKitInterceptor)interceptor);
            }
            OkHttpHook.noDuplicateAdd(interceptors, new DokitMockInterceptor());
            OkHttpHook.noDuplicateAdd(interceptors, new DokitLargePicInterceptor());
            OkHttpHook.noDuplicateAdd(interceptors, new DokitCapInterceptor());
            OkHttpHook.noDuplicateAdd(interceptors, new DokitExtInterceptor());
            OkHttpHook.noDuplicateAdd(networkInterceptors, new DokitWeakNetworkInterceptor());
            ReflectUtils.reflect((Object)client).field("interceptors", interceptors);
            ReflectUtils.reflect((Object)client).field("networkInterceptors", networkInterceptors);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void noDuplicateAdd(List<Interceptor> interceptors, AbsDoKitInterceptor interceptor) {
        boolean hasInterceptor = false;
        for (Interceptor i : interceptors) {
            if (!(i instanceof AbsDoKitInterceptor) || !((AbsDoKitInterceptor)i).getTAG().equals(interceptor.getTAG())) continue;
            hasInterceptor = true;
            break;
        }
        if (!hasInterceptor) {
            interceptors.add(interceptor);
        }
    }
}

