/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.RawRes;
import androidx.core.content.ContextCompat;
import com.didichuxing.doraemonkit.util.Utils;
import com.didichuxing.doraemonkit.util.UtilsBridge;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;

public final class ResourceUtils {
    private static final int BUFFER_SIZE = 8192;

    private ResourceUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Drawable getDrawable(@DrawableRes int id2) {
        return ContextCompat.getDrawable((Context)Utils.getApp(), (int)id2);
    }

    public static int getIdByName(String name) {
        return Utils.getApp().getResources().getIdentifier(name, "id", Utils.getApp().getPackageName());
    }

    public static int getStringIdByName(String name) {
        return Utils.getApp().getResources().getIdentifier(name, "string", Utils.getApp().getPackageName());
    }

    public static int getColorIdByName(String name) {
        return Utils.getApp().getResources().getIdentifier(name, "color", Utils.getApp().getPackageName());
    }

    public static int getDimenIdByName(String name) {
        return Utils.getApp().getResources().getIdentifier(name, "dimen", Utils.getApp().getPackageName());
    }

    public static int getDrawableIdByName(String name) {
        return Utils.getApp().getResources().getIdentifier(name, "drawable", Utils.getApp().getPackageName());
    }

    public static int getMipmapIdByName(String name) {
        return Utils.getApp().getResources().getIdentifier(name, "mipmap", Utils.getApp().getPackageName());
    }

    public static int getLayoutIdByName(String name) {
        return Utils.getApp().getResources().getIdentifier(name, "layout", Utils.getApp().getPackageName());
    }

    public static int getStyleIdByName(String name) {
        return Utils.getApp().getResources().getIdentifier(name, "style", Utils.getApp().getPackageName());
    }

    public static int getAnimIdByName(String name) {
        return Utils.getApp().getResources().getIdentifier(name, "anim", Utils.getApp().getPackageName());
    }

    public static int getMenuIdByName(String name) {
        return Utils.getApp().getResources().getIdentifier(name, "menu", Utils.getApp().getPackageName());
    }

    public static boolean copyFileFromAssets(String assetsFilePath, String destFilePath) {
        boolean res = true;
        try {
            String[] assets = Utils.getApp().getAssets().list(assetsFilePath);
            if (assets != null && assets.length > 0) {
                for (String asset : assets) {
                    res &= ResourceUtils.copyFileFromAssets(assetsFilePath + "/" + asset, destFilePath + "/" + asset);
                }
            } else {
                res = UtilsBridge.writeFileFromIS(destFilePath, Utils.getApp().getAssets().open(assetsFilePath));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            res = false;
        }
        return res;
    }

    public static String readAssets2String(String assetsFilePath) {
        return ResourceUtils.readAssets2String(assetsFilePath, null);
    }

    public static String readAssets2String(String assetsFilePath, String charsetName) {
        try {
            InputStream is = Utils.getApp().getAssets().open(assetsFilePath);
            byte[] bytes = UtilsBridge.inputStream2Bytes(is);
            if (bytes == null) {
                return "";
            }
            if (UtilsBridge.isSpace(charsetName)) {
                return new String(bytes);
            }
            try {
                return new String(bytes, charsetName);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return "";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static List<String> readAssets2List(String assetsPath) {
        return ResourceUtils.readAssets2List(assetsPath, "");
    }

    public static List<String> readAssets2List(String assetsPath, String charsetName) {
        try {
            return UtilsBridge.inputStream2Lines(Utils.getApp().getResources().getAssets().open(assetsPath), charsetName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static boolean copyFileFromRaw(@RawRes int resId, String destFilePath) {
        return UtilsBridge.writeFileFromIS(destFilePath, Utils.getApp().getResources().openRawResource(resId));
    }

    public static String readRaw2String(@RawRes int resId) {
        return ResourceUtils.readRaw2String(resId, null);
    }

    public static String readRaw2String(@RawRes int resId, String charsetName) {
        InputStream is = Utils.getApp().getResources().openRawResource(resId);
        byte[] bytes = UtilsBridge.inputStream2Bytes(is);
        if (bytes == null) {
            return null;
        }
        if (UtilsBridge.isSpace(charsetName)) {
            return new String(bytes);
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static List<String> readRaw2List(@RawRes int resId) {
        return ResourceUtils.readRaw2List(resId, "");
    }

    public static List<String> readRaw2List(@RawRes int resId, String charsetName) {
        return UtilsBridge.inputStream2Lines(Utils.getApp().getResources().openRawResource(resId), charsetName);
    }
}

