/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.core.content.FileProvider;
import com.didichuxing.doraemonkit.util.Utils;
import com.didichuxing.doraemonkit.util.UtilsBridge;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class IntentUtils {
    private IntentUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isIntentAvailable(Intent intent) {
        return Utils.getApp().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    public static Intent getInstallAppIntent(String filePath) {
        return IntentUtils.getInstallAppIntent(UtilsBridge.getFileByPath(filePath));
    }

    public static Intent getInstallAppIntent(File file) {
        Uri uri;
        if (!UtilsBridge.isFileExists(file)) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 24) {
            uri = Uri.fromFile((File)file);
        } else {
            String authority = Utils.getApp().getPackageName() + ".utilcode.provider";
            uri = FileProvider.getUriForFile((Context)Utils.getApp(), (String)authority, (File)file);
        }
        return IntentUtils.getInstallAppIntent(uri);
    }

    public static Intent getInstallAppIntent(Uri uri) {
        if (uri == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        String type = "application/vnd.android.package-archive";
        intent.setDataAndType(uri, type);
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setFlags(1);
        }
        return intent.addFlags(0x10000000);
    }

    public static Intent getUninstallAppIntent(String pkgName) {
        Intent intent = new Intent("android.intent.action.DELETE");
        intent.setData(Uri.parse((String)("package:" + pkgName)));
        return intent.addFlags(0x10000000);
    }

    public static Intent getLaunchAppIntent(String pkgName) {
        String launcherActivity = UtilsBridge.getLauncherActivity(pkgName);
        if (UtilsBridge.isSpace(launcherActivity)) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setClassName(pkgName, launcherActivity);
        return intent.addFlags(0x10000000);
    }

    public static Intent getLaunchAppDetailsSettingsIntent(String pkgName) {
        return IntentUtils.getLaunchAppDetailsSettingsIntent(pkgName, false);
    }

    public static Intent getLaunchAppDetailsSettingsIntent(String pkgName, boolean isNewTask) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + pkgName)));
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getShareTextIntent(String content) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", content);
        intent = Intent.createChooser((Intent)intent, (CharSequence)"");
        return IntentUtils.getIntent(intent, true);
    }

    public static Intent getShareImageIntent(String imagePath) {
        return IntentUtils.getShareTextImageIntent("", imagePath);
    }

    public static Intent getShareImageIntent(File imageFile) {
        return IntentUtils.getShareTextImageIntent("", imageFile);
    }

    public static Intent getShareImageIntent(Uri imageUri) {
        return IntentUtils.getShareTextImageIntent("", imageUri);
    }

    public static Intent getShareTextImageIntent(@Nullable String content, String imagePath) {
        return IntentUtils.getShareTextImageIntent(content, UtilsBridge.getFileByPath(imagePath));
    }

    public static Intent getShareTextImageIntent(@Nullable String content, File imageFile) {
        return IntentUtils.getShareTextImageIntent(content, UtilsBridge.file2Uri(imageFile));
    }

    public static Intent getShareTextImageIntent(@Nullable String content, Uri imageUri) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", content);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)imageUri);
        intent.setType("image/*");
        intent = Intent.createChooser((Intent)intent, (CharSequence)"");
        return IntentUtils.getIntent(intent, true);
    }

    public static Intent getShareImageIntent(LinkedList<String> imagePaths) {
        return IntentUtils.getShareTextImageIntent("", imagePaths);
    }

    public static Intent getShareImageIntent(List<File> images) {
        return IntentUtils.getShareTextImageIntent("", images);
    }

    public static Intent getShareImageIntent(ArrayList<Uri> uris) {
        return IntentUtils.getShareTextImageIntent("", uris);
    }

    public static Intent getShareTextImageIntent(@Nullable String content, LinkedList<String> imagePaths) {
        ArrayList<File> files = new ArrayList<File>();
        if (imagePaths != null) {
            for (String imagePath : imagePaths) {
                File file = UtilsBridge.getFileByPath(imagePath);
                if (file == null) continue;
                files.add(file);
            }
        }
        return IntentUtils.getShareTextImageIntent(content, files);
    }

    public static Intent getShareTextImageIntent(@Nullable String content, List<File> images) {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        if (images != null) {
            for (File image : images) {
                Uri uri = UtilsBridge.file2Uri(image);
                if (uri == null) continue;
                uris.add(uri);
            }
        }
        return IntentUtils.getShareTextImageIntent(content, uris);
    }

    public static Intent getShareTextImageIntent(@Nullable String content, ArrayList<Uri> uris) {
        Intent intent = new Intent("android.intent.action.SEND_MULTIPLE");
        intent.putExtra("android.intent.extra.TEXT", content);
        intent.putParcelableArrayListExtra("android.intent.extra.STREAM", uris);
        intent.setType("image/*");
        intent = Intent.createChooser((Intent)intent, (CharSequence)"");
        return IntentUtils.getIntent(intent, true);
    }

    public static Intent getComponentIntent(String pkgName, String className) {
        return IntentUtils.getComponentIntent(pkgName, className, null, false);
    }

    public static Intent getComponentIntent(String pkgName, String className, boolean isNewTask) {
        return IntentUtils.getComponentIntent(pkgName, className, null, isNewTask);
    }

    public static Intent getComponentIntent(String pkgName, String className, Bundle bundle) {
        return IntentUtils.getComponentIntent(pkgName, className, bundle, false);
    }

    public static Intent getComponentIntent(String pkgName, String className, Bundle bundle, boolean isNewTask) {
        Intent intent = new Intent();
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        ComponentName cn = new ComponentName(pkgName, className);
        intent.setComponent(cn);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getShutdownIntent() {
        Intent intent = Build.VERSION.SDK_INT >= 26 ? new Intent("com.android.internal.intent.action.REQUEST_SHUTDOWN") : new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
        return intent.addFlags(0x10000000);
    }

    public static Intent getDialIntent(@NonNull String phoneNumber) {
        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + Uri.encode((String)phoneNumber))));
        return IntentUtils.getIntent(intent, true);
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public static Intent getCallIntent(@NonNull String phoneNumber) {
        Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + Uri.encode((String)phoneNumber))));
        return IntentUtils.getIntent(intent, true);
    }

    public static Intent getSendSmsIntent(@NonNull String phoneNumber, String content) {
        Uri uri = Uri.parse((String)("smsto:" + Uri.encode((String)phoneNumber)));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", content);
        return IntentUtils.getIntent(intent, true);
    }

    public static Intent getCaptureIntent(Uri outUri) {
        return IntentUtils.getCaptureIntent(outUri, false);
    }

    public static Intent getCaptureIntent(Uri outUri, boolean isNewTask) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)outUri);
        intent.addFlags(1);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    private static Intent getIntent(Intent intent, boolean isNewTask) {
        return isNewTask ? intent.addFlags(0x10000000) : intent;
    }
}

