/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

public final class CoordinateUtils {
    private static final double X_PI = 52.35987755982988;
    private static final double A = 6378245.0;
    private static final double EE = 0.006693421622965943;

    public static double[] bd09ToGcj02(double lng, double lat) {
        double x = lng - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * 52.35987755982988);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        double gg_lng = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        return new double[]{gg_lng, gg_lat};
    }

    public static double[] gcj02ToBd09(double lng, double lat) {
        double z = Math.sqrt(lng * lng + lat * lat) + 2.0E-5 * Math.sin(lat * 52.35987755982988);
        double theta = Math.atan2(lat, lng) + 3.0E-6 * Math.cos(lng * 52.35987755982988);
        double bd_lng = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new double[]{bd_lng, bd_lat};
    }

    public static double[] gcj02ToWGS84(double lng, double lat) {
        if (CoordinateUtils.outOfChina(lng, lat)) {
            return new double[]{lng, lat};
        }
        double dlat = CoordinateUtils.transformLat(lng - 105.0, lat - 35.0);
        double dlng = CoordinateUtils.transformLng(lng - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (6335552.717000426 / (magic * sqrtmagic) * Math.PI);
        dlng = dlng * 180.0 / (6378245.0 / sqrtmagic * Math.cos(radlat) * Math.PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new double[]{lng * 2.0 - mglng, lat * 2.0 - mglat};
    }

    public static double[] wgs84ToGcj02(double lng, double lat) {
        if (CoordinateUtils.outOfChina(lng, lat)) {
            return new double[]{lng, lat};
        }
        double dlat = CoordinateUtils.transformLat(lng - 105.0, lat - 35.0);
        double dlng = CoordinateUtils.transformLng(lng - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (6335552.717000426 / (magic * sqrtmagic) * Math.PI);
        dlng = dlng * 180.0 / (6378245.0 / sqrtmagic * Math.cos(radlat) * Math.PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new double[]{mglng, mglat};
    }

    public static double[] bd09ToWGS84(double lng, double lat) {
        double[] gcj = CoordinateUtils.bd09ToGcj02(lng, lat);
        return CoordinateUtils.gcj02ToWGS84(gcj[0], gcj[1]);
    }

    public static double[] wgs84ToBd09(double lng, double lat) {
        double[] gcj = CoordinateUtils.wgs84ToGcj02(lng, lat);
        return CoordinateUtils.gcj02ToBd09(gcj[0], gcj[1]);
    }

    public static double[] mercatorToWGS84(double lng, double lat) {
        double x = lng / 2.003750834E7 * 180.0;
        double y = lat / 2.003750834E7 * 180.0;
        y = 57.29577951308232 * (2.0 * Math.atan(Math.exp(y * Math.PI / 180.0)) - 1.5707963267948966);
        return new double[]{x, y};
    }

    public static double[] wgs84ToMercator(double lng, double lat) {
        double x = lng * 2.003750834E7 / 180.0;
        double y = Math.log(Math.tan((90.0 + lat) * Math.PI / 360.0)) / (Math.PI / 180);
        y = y * 2.003750834E7 / 180.0;
        return new double[]{x, y};
    }

    private static double transformLat(double lng, double lat) {
        double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat + 0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lat / 12.0 * Math.PI) + 320.0 * Math.sin(lat * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    private static double transformLng(double lng, double lat) {
        double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng + 0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lng * Math.PI) + 40.0 * Math.sin(lng / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lng / 12.0 * Math.PI) + 300.0 * Math.sin(lng / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    private static boolean outOfChina(double lng, double lat) {
        return lng < 72.004 || lng > 137.8347 || lat < 0.8293 || lat > 55.8271;
    }
}

