/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import android.content.Context;
import com.didichuxing.doraemonkit.util.Utils;

public final class ClipboardUtils {
    private ClipboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void copyText(CharSequence text) {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        cm.setPrimaryClip(ClipData.newPlainText((CharSequence)Utils.getApp().getPackageName(), (CharSequence)text));
    }

    public static void copyText(CharSequence label, CharSequence text) {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        cm.setPrimaryClip(ClipData.newPlainText((CharSequence)label, (CharSequence)text));
    }

    public static void clear() {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        cm.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)""));
    }

    public static CharSequence getLabel() {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        ClipDescription des = cm.getPrimaryClipDescription();
        if (des == null) {
            return "";
        }
        CharSequence label = des.getLabel();
        if (label == null) {
            return "";
        }
        return label;
    }

    public static CharSequence getText() {
        CharSequence text;
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        ClipData clip = cm.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0 && (text = clip.getItemAt(0).coerceToText((Context)Utils.getApp())) != null) {
            return text;
        }
        return "";
    }

    public static void addChangedListener(ClipboardManager.OnPrimaryClipChangedListener listener) {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        cm.addPrimaryClipChangedListener(listener);
    }

    public static void removeChangedListener(ClipboardManager.OnPrimaryClipChangedListener listener) {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        cm.removePrimaryClipChangedListener(listener);
    }
}

