/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.plugin;

import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0004J,\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/didichuxing/doraemonkit/plugin/DoKitPluginUtil;", "", "()V", "BYTE", "", "GB", "KB", "MB", "byte2FitMemorySize", "", "byteSize", "", "precision", "compareVersion", "version1", "version2", "fileSize", "file", "Ljava/io/File;", "getNextChunk", "Lkotlin/Pair;", "version", "n", "p", "dokit-plugin"})
public final class DoKitPluginUtil {
    public static final int BYTE = 1;
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    public static final DoKitPluginUtil INSTANCE;

    @Nullable
    public final String fileSize(@NotNull File file, int precision) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!file.isFile()) {
            return "0kb";
        }
        if (file.isDirectory()) {
            return "0kb";
        }
        long fileLength = file.length();
        return this.byte2FitMemorySize(fileLength, precision);
    }

    private final String byte2FitMemorySize(long byteSize, int precision) {
        String string;
        boolean bl = precision >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "precision shouldn't be less than zero!";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (byteSize < 0L) {
            throw (Throwable)new IllegalArgumentException("byteSize shouldn't be less than zero!");
        }
        if (byteSize < (long)1024) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%." + precision + "fB";
            Object[] objectArray = new Object[]{(double)byteSize};
            boolean bl5 = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        } else if (byteSize < (long)0x100000) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string5 = "%." + precision + "fKB";
            Object[] objectArray = new Object[]{(double)byteSize / (double)1024};
            boolean bl6 = false;
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
        } else if (byteSize < (long)0x40000000) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string7 = "%." + precision + "fMB";
            Object[] objectArray = new Object[]{(double)byteSize / (double)0x100000};
            boolean bl7 = false;
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"java.lang.String.format(format, *args)");
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string9 = "%." + precision + "fGB";
            Object[] objectArray = new Object[]{(double)byteSize / (double)0x40000000};
            boolean bl8 = false;
            String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"java.lang.String.format(format, *args)");
        }
        return string;
    }

    private final Pair<Integer, Integer> getNextChunk(String version, int n, int p) {
        int n2;
        boolean bl;
        String string;
        int pEnd;
        if (p > n - 1) {
            return new Pair((Object)0, (Object)p);
        }
        int i = 0;
        for (pEnd = p; pEnd < n && Character.valueOf(version.charAt(pEnd)).equals("."); ++pEnd) {
        }
        if (pEnd != n - 1) {
            string = version;
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(p, pEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            bl = false;
            n2 = Integer.parseInt(string);
        } else {
            string = version;
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(p, n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string5;
            bl = false;
            n2 = Integer.parseInt(string);
        }
        i = n2;
        int q = pEnd + 1;
        return new Pair((Object)i, (Object)q);
    }

    public final int compareVersion(@NotNull String version1, @NotNull String version2) {
        Intrinsics.checkParameterIsNotNull((Object)version1, (String)"version1");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version2");
        int p1 = 0;
        int p2 = 0;
        int n1 = version1.length();
        int n2 = version2.length();
        int i1 = 0;
        int i2 = 0;
        Pair<Integer, Integer> pair = null;
        while (p1 < n1 || p2 < n2) {
            pair = this.getNextChunk(version1, n1, p1);
            i1 = ((Number)pair.getFirst()).intValue();
            p1 = ((Number)pair.getSecond()).intValue();
            pair = this.getNextChunk(version2, n2, p2);
            i2 = ((Number)pair.getFirst()).intValue();
            p2 = ((Number)pair.getSecond()).intValue();
            if (i1 == i2) continue;
            return i1 > i2 ? 1 : -1;
        }
        return 0;
    }

    private DoKitPluginUtil() {
    }

    static {
        DoKitPluginUtil doKitPluginUtil;
        INSTANCE = doKitPluginUtil = new DoKitPluginUtil();
    }
}

