/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.SellingPartnerAPIAA;

import com.amazonaws.ReadLimitInfo;
import com.amazonaws.SignableRequest;
import com.amazonaws.http.HttpMethodName;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.http.client.utils.URLEncodedUtils;

class SignableRequestImpl
implements SignableRequest<Request> {
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private Request originalRequest;
    private Request.Builder signableRequestBuilder;

    SignableRequestImpl(Request originalRequest) {
        this.originalRequest = originalRequest;
        this.signableRequestBuilder = originalRequest.newBuilder();
    }

    public void addHeader(String name, String value) {
        this.signableRequestBuilder.addHeader(name, value);
    }

    public void addParameter(String name, String value) {
        HttpUrl newUrl = this.signableRequestBuilder.build().httpUrl().newBuilder().addEncodedQueryParameter(name, value).build();
        this.signableRequestBuilder.url(newUrl);
    }

    public void setContent(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getHeaders() {
        MediaType contentType;
        HashMap<String, String> headers = new HashMap<String, String>();
        Request requestSnapshot = this.signableRequestBuilder.build();
        requestSnapshot.headers().names().forEach(headerName -> headers.put((String)headerName, requestSnapshot.header(headerName)));
        if (requestSnapshot.body() != null && (contentType = requestSnapshot.body().contentType()) != null) {
            headers.put(CONTENT_TYPE_HEADER_NAME, contentType.toString());
        }
        return headers;
    }

    public String getResourcePath() {
        return this.originalRequest.url().getPath();
    }

    public Map<String, List<String>> getParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        try {
            List nameValuePairs = URLEncodedUtils.parse((URI)this.originalRequest.url().toURI(), (Charset)StandardCharsets.UTF_8);
            nameValuePairs.forEach(nameValuePair -> parameters.put(nameValuePair.getName(), Collections.singletonList(nameValuePair.getValue())));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return parameters;
    }

    public URI getEndpoint() {
        URI uri = null;
        try {
            uri = this.originalRequest.url().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return URI.create(String.format("%s://%s", uri.getScheme(), uri.getHost()));
    }

    public HttpMethodName getHttpMethod() {
        return HttpMethodName.fromValue((String)this.originalRequest.method().toUpperCase());
    }

    public int getTimeOffset() {
        return 0;
    }

    public InputStream getContent() {
        ByteArrayInputStream inputStream = null;
        if (this.originalRequest.body() != null) {
            try {
                Buffer buffer = new Buffer();
                this.originalRequest.body().writeTo((BufferedSink)buffer);
                inputStream = new ByteArrayInputStream(buffer.readByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to buffer request body", e);
            }
        }
        return inputStream;
    }

    public InputStream getContentUnwrapped() {
        return this.getContent();
    }

    public ReadLimitInfo getReadLimitInfo() {
        return null;
    }

    public Object getOriginalRequestObject() {
        return this.signableRequestBuilder.build();
    }
}

