/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.SellingPartnerAPIAA;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenRequestMeta;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAClient;
import com.squareup.okhttp.Request;

public class LWAAuthorizationSigner {
    private static final String SIGNED_ACCESS_TOKEN_HEADER_NAME = "x-amz-access-token";
    private LWAClient lwaClient;
    private LWAAccessTokenRequestMeta lwaAccessTokenRequestMeta;

    private void buildLWAAccessTokenRequestMeta(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
        String tokenRequestGrantType = !lwaAuthorizationCredentials.getScopes().isEmpty() ? "client_credentials" : "refresh_token";
        this.lwaAccessTokenRequestMeta = LWAAccessTokenRequestMeta.builder().clientId(lwaAuthorizationCredentials.getClientId()).clientSecret(lwaAuthorizationCredentials.getClientSecret()).refreshToken(lwaAuthorizationCredentials.getRefreshToken()).grantType(tokenRequestGrantType).scopes(lwaAuthorizationCredentials.getScopes()).build();
    }

    public LWAAuthorizationSigner(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
        this.lwaClient = new LWAClient(lwaAuthorizationCredentials.getEndpoint());
        this.buildLWAAccessTokenRequestMeta(lwaAuthorizationCredentials);
    }

    public LWAAuthorizationSigner(LWAAuthorizationCredentials lwaAuthorizationCredentials, LWAAccessTokenCache lwaAccessTokenCache) {
        this.lwaClient = new LWAClient(lwaAuthorizationCredentials.getEndpoint());
        this.lwaClient.setLWAAccessTokenCache(lwaAccessTokenCache);
        this.buildLWAAccessTokenRequestMeta(lwaAuthorizationCredentials);
    }

    public Request sign(Request originalRequest) {
        String accessToken = this.lwaClient.getAccessToken(this.lwaAccessTokenRequestMeta);
        return originalRequest.newBuilder().addHeader(SIGNED_ACCESS_TOKEN_HEADER_NAME, accessToken).build();
    }

    LWAClient getLwaClient() {
        return this.lwaClient;
    }

    void setLwaClient(LWAClient lwaClient) {
        this.lwaClient = lwaClient;
    }
}

