/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.SellingPartnerAPIAA;

import com.amazon.SellingPartnerAPIAA.AWSAuthenticationCredentials;
import com.amazon.SellingPartnerAPIAA.AWSAuthenticationCredentialsProvider;
import com.amazon.SellingPartnerAPIAA.SignableRequestImpl;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.squareup.okhttp.Request;

public class AWSSigV4Signer {
    private static final String SERVICE_NAME = "execute-api";
    private AWS4Signer aws4Signer = new AWS4Signer();
    private AWSCredentials awsCredentials;
    private AWSCredentialsProvider awsCredentialsProvider;

    public AWSSigV4Signer(AWSAuthenticationCredentials awsAuthenticationCredentials) {
        this.aws4Signer.setServiceName(SERVICE_NAME);
        this.aws4Signer.setRegionName(awsAuthenticationCredentials.getRegion());
        this.awsCredentials = new BasicAWSCredentials(awsAuthenticationCredentials.getAccessKeyId(), awsAuthenticationCredentials.getSecretKey());
    }

    public AWSSigV4Signer(AWSAuthenticationCredentials awsAuthenticationCredentials, AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider) {
        this.aws4Signer.setServiceName(SERVICE_NAME);
        this.aws4Signer.setRegionName(awsAuthenticationCredentials.getRegion());
        BasicAWSCredentials awsBasicCredentials = new BasicAWSCredentials(awsAuthenticationCredentials.getAccessKeyId(), awsAuthenticationCredentials.getSecretKey());
        this.awsCredentialsProvider = new STSAssumeRoleSessionCredentialsProvider.Builder(awsAuthenticationCredentialsProvider.getRoleArn(), awsAuthenticationCredentialsProvider.getRoleSessionName()).withStsClient((AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(awsAuthenticationCredentials.getRegion())).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsBasicCredentials))).build()).build();
    }

    public Request sign(Request originalRequest) {
        SignableRequestImpl signableRequest = new SignableRequestImpl(originalRequest);
        if (this.awsCredentialsProvider != null) {
            this.aws4Signer.sign((SignableRequest)signableRequest, this.awsCredentialsProvider.getCredentials());
        } else {
            this.aws4Signer.sign((SignableRequest)signableRequest, this.awsCredentials);
        }
        return (Request)signableRequest.getOriginalRequestObject();
    }

    void setAws4Signer(AWS4Signer aws4Signer) {
        this.aws4Signer = aws4Signer;
    }

    AWS4Signer getAws4Signer() {
        return this.aws4Signer;
    }

    void setAwsCredentialsProvider(AWSCredentialsProvider awsCredentialsProvider) {
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    AWSCredentialsProvider getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }
}

