/*
 * Decompiled with CFR 0.152.
 */
package io.github.dft.amazon;

import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import io.github.dft.amazon.AmazonSellingPartnerSdk;
import io.github.dft.amazon.model.AmazonCredentials;
import io.github.dft.amazon.model.handler.JsonBodyHandler;
import io.github.dft.amazon.model.listing.v20210801.ListingItemsWrapper;
import io.github.dft.amazon.model.listing.v20210801.ListingsItemPatchRequest;
import io.github.dft.amazon.model.listing.v20210801.ListingsItemSubmissionResponse;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.HashMap;

public class AmazonSPListingItemsAPI
extends AmazonSellingPartnerSdk {
    public AmazonSPListingItemsAPI(AmazonCredentials amazonCredentials) {
        super(amazonCredentials);
    }

    public ListingItemsWrapper getListingItemsBySellerIdAndSku(String sellerId, String sku, HashMap<String, String> params) {
        URI uri = URI.create(this.sellingRegionEndpoint + "/listings/2021-08-01/items/" + sellerId + "/" + sku);
        uri = this.addParameters(uri, params);
        DefaultRequest<Object> signRequest = this.signRequest(String.valueOf(uri), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<ListingItemsWrapper> handler = new JsonBodyHandler<ListingItemsWrapper>(ListingItemsWrapper.class);
        return this.getRequestWrapped(request, handler);
    }

    public ListingsItemSubmissionResponse patchListingsItem(String sellerId, String sku, HashMap<String, String> params, ListingsItemPatchRequest patchRequest) {
        String strFormattedUrl = String.format(this.sellingRegionEndpoint + "/listings/2021-08-01/items/%s/%s", sellerId, sku);
        URI uri = URI.create(strFormattedUrl);
        uri = this.addParameters(uri, params);
        DefaultRequest<Object> signRequest = this.signRequest(String.valueOf(uri), HttpMethodName.PATCH, null, null);
        String payload = this.getString(patchRequest);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).method(HttpMethodName.PATCH.name(), HttpRequest.BodyPublishers.ofString(payload)).build();
        JsonBodyHandler<ListingsItemSubmissionResponse> handler = new JsonBodyHandler<ListingsItemSubmissionResponse>(ListingsItemSubmissionResponse.class);
        return this.getRequestWrapped(request, handler);
    }
}

