/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.annotation.Extension;
import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.IPrepareAware;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalAopUtils;
import io.github.dddplus.runtime.registry.InternalIndexer;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionDef
implements IRegistryAware,
IPrepareAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtensionDef.class);
    private String code;
    private String name;
    private Class<? extends IDomainExtension> extClazz;
    private IDomainExtension extensionBean;

    public ExtensionDef() {
    }

    public ExtensionDef(IDomainExtension extensionBean) {
        this.extensionBean = extensionBean;
    }

    @Override
    public void registerBean(@NotNull Object bean) {
        this.initialize(bean);
        InternalIndexer.index(this);
    }

    @Override
    public void prepare(@NotNull Object bean) {
        this.initialize(bean);
        InternalIndexer.prepare(this);
    }

    private void initialize(Object bean) {
        Extension extension = InternalAopUtils.getAnnotation(bean, Extension.class);
        this.code = extension.code();
        this.name = extension.name();
        if (!(bean instanceof IDomainExtension)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " MUST implement IDomainExtension");
        }
        this.extensionBean = (IDomainExtension)bean;
        for (Class<?> extensionBeanInterfaceClazz : InternalAopUtils.getTarget(this.extensionBean).getClass().getInterfaces()) {
            if (!extensionBeanInterfaceClazz.isInstance(this.extensionBean)) continue;
            this.extClazz = extensionBeanInterfaceClazz;
            log.debug("{} has ext instance:{}", (Object)this.extClazz.getCanonicalName(), (Object)this);
            break;
        }
    }

    @Generated
    public String toString() {
        return "ExtensionDef(code=" + this.getCode() + ", name=" + this.getName() + ", extClazz=" + this.getExtClazz() + ", extensionBean=" + this.getExtensionBean() + ")";
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Class<? extends IDomainExtension> getExtClazz() {
        return this.extClazz;
    }

    @Generated
    public IDomainExtension getExtensionBean() {
        return this.extensionBean;
    }
}

