/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime;

import io.github.dddplus.runtime.IReducer;
import java.util.List;
import java.util.function.Predicate;

public abstract class Reducer<R>
implements IReducer<R> {
    public static <R> Reducer<R> firstOf(final Predicate<R> predicate) {
        return new Reducer<R>(){

            @Override
            public R reduce(List<R> accumulatedResults) {
                Object result = null;
                if (accumulatedResults != null && !accumulatedResults.isEmpty()) {
                    result = accumulatedResults.get(0);
                }
                return result;
            }

            @Override
            public boolean shouldStop(List<R> accumulatedResults) {
                boolean result = false;
                if (accumulatedResults != null && !accumulatedResults.isEmpty()) {
                    result = predicate.test(accumulatedResults.get(accumulatedResults.size() - 1));
                }
                return result;
            }
        };
    }

    public static <R> Reducer<R> all(final Predicate<R> predicate) {
        return new Reducer<R>(){

            @Override
            public R reduce(List<R> accumulatedResults) {
                if (predicate == null) {
                    return null;
                }
                for (Object r : accumulatedResults) {
                    if (!predicate.test(r)) continue;
                    return r;
                }
                return null;
            }

            @Override
            public boolean shouldStop(List<R> accumulatedResults) {
                return false;
            }
        };
    }
}

