/*
 * Decompiled with CFR 0.152.
 */
package io.github.dayeshing.apiface.gradle;

import io.github.dayeshing.apiface.core.util.ObjectUtil;
import io.github.dayeshing.apiface.gradle.ApiExtension;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public abstract class AbstractFaceTask
extends DefaultTask {
    public static final String SUFFIX = ".json";
    public static final String DIRECTORY = "apiface";
    protected ClassLoader classLoader;
    protected Project project;
    protected ApiExtension apiExtension;
    protected File sourseDirectory;
    protected File outputDirectory;

    protected abstract byte[] process();

    protected abstract File dist();

    protected boolean isExecute() {
        return true;
    }

    protected abstract String mojo();

    @TaskAction
    public void action() {
        this.project = this.getProject();
        this.apiExtension = (ApiExtension)this.project.getExtensions().getByType(ApiExtension.class);
        this.sourseDirectory = new File(String.format("%s/src/main/java", this.project.getProjectDir()));
        this.outputDirectory = new File(String.format("%s/classes/java/main", this.project.getBuildDir()));
        try {
            this.classLoader = this.getClassLoader();
            this.before();
            byte[] process = this.process();
            if (process != null) {
                ObjectUtil.write((File)this.dist(), (byte[])process);
            }
            this.after();
        }
        catch (Exception e) {
            this.getLog(String.format("----------->> \u6784\u5efa %s \u6a21\u5757\u7684%s\u5931\u8d25 <<-----------", this.project.getName(), this.mojo()));
            e.printStackTrace();
        }
        this.apiExtension = (ApiExtension)this.project.getExtensions().getByType(ApiExtension.class);
    }

    protected void getLog(String log) {
        System.out.println(log);
    }

    protected boolean before() {
        this.getLog(String.format("----------->> \u6b63\u5728\u6784\u5efa %s \u6a21\u5757\u7684%s <<-----------", this.project.getName(), this.mojo()));
        return true;
    }

    protected boolean after() {
        this.getLog(String.format("----------->> \u6210\u529f\u6784\u5efa %s \u6a21\u5757\u7684%s <<-----------", this.project.getName(), this.mojo()));
        return true;
    }

    protected String getFilename(String filename) {
        return filename + SUFFIX;
    }

    protected List<String> jar(Project p, String dir) {
        File[] files;
        File file = new File(p.getBuildDir(), dir);
        ArrayList<String> ret = new ArrayList<String>();
        for (File f : files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith("jar");
            }
        })) {
            ret.add(f.getAbsolutePath());
        }
        ret.add(this.outputDirectory.getAbsolutePath());
        return ret;
    }

    protected List<String> getCompileClasspathElements(Project p) {
        return this.jar(p, "jars");
    }

    protected ClassLoader getClassLoader() {
        List<String> classPath = this.getCompileClasspathElements(this.project);
        ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
        for (String jar : classPath) {
            try {
                urls.add(new File(jar).toURL());
            }
            catch (Exception var6) {
                this.getLog(String.format("----------->> \u52a0\u8f7d\u5305 %s \u5931\u8d25 <<-----------", jar));
            }
        }
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        return loader;
    }

    private TreeMap<String, Project> getAllModule(Project rootProject) {
        TreeMap<String, Project> result = new TreeMap<String, Project>();
        if (rootProject == null) {
            return result;
        }
        if (rootProject.getDepth() != 0) {
            result.put(rootProject.getGroup() + ":" + rootProject.getName(), rootProject);
        }
        if (rootProject.getChildProjects().isEmpty()) {
            return result;
        }
        Map map = rootProject.getChildProjects();
        for (Map.Entry entry : map.entrySet()) {
            TreeMap<String, Project> module = this.getAllModule((Project)entry.getValue());
            result.putAll(module);
        }
        return result;
    }
}

