/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter4.loadState.trailing;

import androidx.annotation.CallSuper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.chad.library.adapter4.loadState.LoadState;
import com.chad.library.adapter4.loadState.LoadStateAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001/B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u001cH\u0002J\u001d\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b#J\u0006\u0010$\u001a\u00020\u001cJ\u0006\u0010%\u001a\u00020\u001cJ\u0006\u0010&\u001a\u00020\u001cJ\b\u0010'\u001a\u00020\u0005H\u0002J\u0012\u0010(\u001a\u00020\u00112\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010,\u001a\u0004\u0018\u00010\nJ\b\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\u0007R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/chad/library/adapter4/loadState/trailing/TrailingLoadStateAdapter;", "VH", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/chad/library/adapter4/loadState/LoadStateAdapter;", "isLoadEndDisplay", "", "<init>", "(Z)V", "()Z", "value", "Lcom/chad/library/adapter4/loadState/trailing/TrailingLoadStateAdapter$OnTrailingListener;", "onTrailingListener", "getOnTrailingListener", "()Lcom/chad/library/adapter4/loadState/trailing/TrailingLoadStateAdapter$OnTrailingListener;", "isAutoLoadMore", "setAutoLoadMore", "preloadSize", "", "getPreloadSize", "()I", "setPreloadSize", "(I)V", "mNotFullPageNextLoadFlag", "mDelayNextLoadFlag", "displayLoadStateAsItem", "loadState", "Lcom/chad/library/adapter4/loadState/LoadState;", "onViewAttachedToWindow", "", "holder", "(Landroidx/recyclerview/widget/RecyclerView$ViewHolder;)V", "loadAction", "checkPreload", "itemCount", "currentPosition", "checkPreload$com_github_CymChad_brvah", "invokeLoadMore", "invokeFailRetry", "checkDisableLoadMoreIfNotFullPage", "isFullScreen", "getTheBiggestNumber", "numbers", "", "setOnLoadMoreListener", "listener", "toString", "", "OnTrailingListener", "com.github.CymChad.brvah"})
public abstract class TrailingLoadStateAdapter<VH extends RecyclerView.ViewHolder>
extends LoadStateAdapter<VH> {
    private final boolean isLoadEndDisplay;
    @Nullable
    private OnTrailingListener onTrailingListener;
    private boolean isAutoLoadMore;
    private int preloadSize;
    private boolean mNotFullPageNextLoadFlag;
    private boolean mDelayNextLoadFlag;

    public TrailingLoadStateAdapter(boolean isLoadEndDisplay) {
        this.isLoadEndDisplay = isLoadEndDisplay;
        this.isAutoLoadMore = true;
    }

    public /* synthetic */ TrailingLoadStateAdapter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean isLoadEndDisplay() {
        return this.isLoadEndDisplay;
    }

    @Nullable
    public final OnTrailingListener getOnTrailingListener() {
        return this.onTrailingListener;
    }

    public final boolean isAutoLoadMore() {
        return this.isAutoLoadMore;
    }

    public final void setAutoLoadMore(boolean bl) {
        this.isAutoLoadMore = bl;
    }

    public final int getPreloadSize() {
        return this.preloadSize;
    }

    public final void setPreloadSize(int n) {
        this.preloadSize = n;
    }

    @Override
    public boolean displayLoadStateAsItem(@NotNull LoadState loadState) {
        Intrinsics.checkNotNullParameter((Object)loadState, (String)"loadState");
        return super.displayLoadStateAsItem(loadState) || loadState instanceof LoadState.NotLoading && !loadState.getEndOfPaginationReached() || this.isLoadEndDisplay && loadState instanceof LoadState.NotLoading && loadState.getEndOfPaginationReached();
    }

    @CallSuper
    public void onViewAttachedToWindow(@NotNull VH holder) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        if (this.preloadSize == 0) {
            this.loadAction();
        }
    }

    private final void loadAction() {
        block8: {
            block7: {
                if (!this.isAutoLoadMore) break block7;
                OnTrailingListener onTrailingListener = this.onTrailingListener;
                boolean bl = onTrailingListener != null ? !onTrailingListener.isAllowLoading() : false;
                if (!bl) break block8;
            }
            return;
        }
        if (this.mNotFullPageNextLoadFlag || this.mDelayNextLoadFlag) {
            return;
        }
        if (this.getLoadState() instanceof LoadState.NotLoading && !this.getLoadState().getEndOfPaginationReached()) {
            RecyclerView recyclerView = this.getRecyclerView();
            if (recyclerView == null) {
                return;
            }
            RecyclerView recyclerView2 = recyclerView;
            if (recyclerView2.isComputingLayout()) {
                this.mDelayNextLoadFlag = true;
                recyclerView2.post(() -> TrailingLoadStateAdapter.loadAction$lambda$0(this));
                return;
            }
            this.invokeLoadMore();
        }
    }

    public final void checkPreload$com_github_CymChad_brvah(int itemCount, int currentPosition) {
        if (currentPosition > itemCount - 1) {
            return;
        }
        if (this.preloadSize > 0 && itemCount - currentPosition - 1 <= this.preloadSize) {
            this.loadAction();
        }
    }

    public final void invokeLoadMore() {
        block0: {
            this.setLoadState(LoadState.Loading.INSTANCE);
            OnTrailingListener onTrailingListener = this.onTrailingListener;
            if (onTrailingListener == null) break block0;
            onTrailingListener.onLoad();
        }
    }

    public final void invokeFailRetry() {
        block0: {
            this.setLoadState(LoadState.Loading.INSTANCE);
            OnTrailingListener onTrailingListener = this.onTrailingListener;
            if (onTrailingListener == null) break block0;
            onTrailingListener.onFailRetry();
        }
    }

    public final void checkDisableLoadMoreIfNotFullPage() {
        this.mNotFullPageNextLoadFlag = true;
        RecyclerView recyclerView = this.getRecyclerView();
        if (recyclerView == null) {
            return;
        }
        RecyclerView recyclerView2 = recyclerView;
        RecyclerView.LayoutManager layoutManager = recyclerView2.getLayoutManager();
        if (layoutManager == null) {
            return;
        }
        RecyclerView.LayoutManager manager = layoutManager;
        if (manager instanceof LinearLayoutManager) {
            recyclerView2.post(() -> TrailingLoadStateAdapter.checkDisableLoadMoreIfNotFullPage$lambda$1(this));
        } else if (manager instanceof StaggeredGridLayoutManager) {
            recyclerView2.post(() -> TrailingLoadStateAdapter.checkDisableLoadMoreIfNotFullPage$lambda$2(manager, this, recyclerView2));
        }
    }

    private final boolean isFullScreen() {
        RecyclerView recyclerView = this.getRecyclerView();
        if (recyclerView == null || (recyclerView = recyclerView.getAdapter()) == null) {
            return true;
        }
        RecyclerView adapter = recyclerView;
        RecyclerView recyclerView2 = this.getRecyclerView();
        RecyclerView.LayoutManager layoutManager = recyclerView2 != null ? recyclerView2.getLayoutManager() : null;
        LinearLayoutManager linearLayoutManager = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
        if (linearLayoutManager == null) {
            return true;
        }
        LinearLayoutManager llm = linearLayoutManager;
        return llm.findLastCompletelyVisibleItemPosition() + 1 != adapter.getItemCount() || llm.findFirstCompletelyVisibleItemPosition() != 0;
    }

    private final int getTheBiggestNumber(int[] numbers) {
        int tmp = -1;
        if (numbers == null || numbers.length == 0) {
            return tmp;
        }
        for (int num : numbers) {
            if (num <= tmp) continue;
            tmp = num;
        }
        return tmp;
    }

    @NotNull
    public final TrailingLoadStateAdapter<VH> setOnLoadMoreListener(@Nullable OnTrailingListener listener2) {
        TrailingLoadStateAdapter trailingLoadStateAdapter;
        TrailingLoadStateAdapter $this$setOnLoadMoreListener_u24lambda_u243 = trailingLoadStateAdapter = this;
        boolean bl = false;
        $this$setOnLoadMoreListener_u24lambda_u243.onTrailingListener = listener2;
        return trailingLoadStateAdapter;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            TrailingLoadStateAdapter ->\n            [isLoadEndDisplay: " + this.isLoadEndDisplay + "],\n            [isAutoLoadMore: " + this.isAutoLoadMore + "],\n            [preloadSize: " + this.preloadSize + "],\n            [loadState: " + this.getLoadState() + "]\n        "));
    }

    private static final void loadAction$lambda$0(TrailingLoadStateAdapter this$0) {
        this$0.mDelayNextLoadFlag = false;
        this$0.invokeLoadMore();
    }

    private static final void checkDisableLoadMoreIfNotFullPage$lambda$1(TrailingLoadStateAdapter this$0) {
        if (this$0.isFullScreen()) {
            this$0.mNotFullPageNextLoadFlag = false;
        }
    }

    private static final void checkDisableLoadMoreIfNotFullPage$lambda$2(RecyclerView.LayoutManager $manager, TrailingLoadStateAdapter this$0, RecyclerView $recyclerView) {
        int[] positions = new int[((StaggeredGridLayoutManager)$manager).getSpanCount()];
        ((StaggeredGridLayoutManager)$manager).findLastCompletelyVisibleItemPositions(positions);
        int pos = this$0.getTheBiggestNumber(positions) + 1;
        RecyclerView.Adapter adapter = $recyclerView.getAdapter();
        if (!(adapter != null ? pos == adapter.getItemCount() : false)) {
            this$0.mNotFullPageNextLoadFlag = false;
        }
    }

    public TrailingLoadStateAdapter() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/chad/library/adapter4/loadState/trailing/TrailingLoadStateAdapter$OnTrailingListener;", "", "onLoad", "", "onFailRetry", "isAllowLoading", "", "com.github.CymChad.brvah"})
    public static interface OnTrailingListener {
        public void onLoad();

        public void onFailRetry();

        default public boolean isAllowLoading() {
            return true;
        }
    }
}

