/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.module;

import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.listener.LoadMoreListenerImp;
import com.chad.library.adapter.base.listener.OnLoadMoreListener;
import com.chad.library.adapter.base.loadmore.BaseLoadMoreView;
import com.chad.library.adapter.base.loadmore.LoadMoreStatus;
import com.chad.library.adapter.base.module.LoadMoreModuleConfig;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.J\u0006\u0010/\u001a\u00020+J\u0006\u00100\u001a\u00020\tJ\u0015\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b3J\b\u00104\u001a\u00020+H\u0002J\u0006\u00105\u001a\u00020+J\u0010\u00106\u001a\u00020\t2\u0006\u00107\u001a\u000208H\u0002J\u0012\u00109\u001a\u00020\u001f2\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u0012\u0010<\u001a\u00020+2\b\b\u0002\u0010=\u001a\u00020\tH\u0007J\u0006\u0010>\u001a\u00020+J\u0006\u0010?\u001a\u00020+J\u0012\u0010@\u001a\u00020+2\b\u0010A\u001a\u0004\u0018\u00010\u0007H\u0016J\r\u0010B\u001a\u00020+H\u0000\u00a2\u0006\u0002\bCR\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0010\"\u0004\b\u001c\u0010\u001aR\u001a\u0010\u001d\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u001aR$\u0010 \u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0010R\u0011\u0010&\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\"R$\u0010(\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0010\"\u0004\b)\u0010\u001a\u00a8\u0006D"}, d2={"Lcom/chad/library/adapter/base/module/BaseLoadMoreModule;", "Lcom/chad/library/adapter/base/listener/LoadMoreListenerImp;", "baseQuickAdapter", "Lcom/chad/library/adapter/base/BaseQuickAdapter;", "<init>", "(Lcom/chad/library/adapter/base/BaseQuickAdapter;)V", "mLoadMoreListener", "Lcom/chad/library/adapter/base/listener/OnLoadMoreListener;", "mNextLoadEnable", "", "value", "Lcom/chad/library/adapter/base/loadmore/LoadMoreStatus;", "loadMoreStatus", "getLoadMoreStatus", "()Lcom/chad/library/adapter/base/loadmore/LoadMoreStatus;", "isLoadEndMoreGone", "()Z", "loadMoreView", "Lcom/chad/library/adapter/base/loadmore/BaseLoadMoreView;", "getLoadMoreView", "()Lcom/chad/library/adapter/base/loadmore/BaseLoadMoreView;", "setLoadMoreView", "(Lcom/chad/library/adapter/base/loadmore/BaseLoadMoreView;)V", "enableLoadMoreEndClick", "getEnableLoadMoreEndClick", "setEnableLoadMoreEndClick", "(Z)V", "isAutoLoadMore", "setAutoLoadMore", "isEnableLoadMoreIfNotFullPage", "setEnableLoadMoreIfNotFullPage", "", "preLoadNumber", "getPreLoadNumber", "()I", "setPreLoadNumber", "(I)V", "isLoading", "loadMoreViewPosition", "getLoadMoreViewPosition", "isEnableLoadMore", "setEnableLoadMore", "setupViewHolder", "", "viewHolder", "Lcom/chad/library/adapter/base/viewholder/BaseViewHolder;", "setupViewHolder$com_github_CymChad_brvah", "loadMoreToLoading", "hasLoadMoreView", "autoLoadMore", "position", "autoLoadMore$com_github_CymChad_brvah", "invokeLoadMoreListener", "checkDisableLoadMoreIfNotFullPage", "isFullScreen", "llm", "Landroidx/recyclerview/widget/LinearLayoutManager;", "getTheBiggestNumber", "numbers", "", "loadMoreEnd", "gone", "loadMoreComplete", "loadMoreFail", "setOnLoadMoreListener", "listener", "reset", "reset$com_github_CymChad_brvah", "com.github.CymChad.brvah"})
public class BaseLoadMoreModule
implements LoadMoreListenerImp {
    @NotNull
    private final BaseQuickAdapter<?, ?> baseQuickAdapter;
    @Nullable
    private OnLoadMoreListener mLoadMoreListener;
    private boolean mNextLoadEnable;
    @NotNull
    private LoadMoreStatus loadMoreStatus;
    private boolean isLoadEndMoreGone;
    @NotNull
    private BaseLoadMoreView loadMoreView;
    private boolean enableLoadMoreEndClick;
    private boolean isAutoLoadMore;
    private boolean isEnableLoadMoreIfNotFullPage;
    private int preLoadNumber;
    private boolean isEnableLoadMore;

    public BaseLoadMoreModule(@NotNull BaseQuickAdapter<?, ?> baseQuickAdapter) {
        Intrinsics.checkNotNullParameter(baseQuickAdapter, (String)"baseQuickAdapter");
        this.baseQuickAdapter = baseQuickAdapter;
        this.mNextLoadEnable = true;
        this.loadMoreStatus = LoadMoreStatus.Complete;
        this.loadMoreView = LoadMoreModuleConfig.getDefLoadMoreView();
        this.isAutoLoadMore = true;
        this.isEnableLoadMoreIfNotFullPage = true;
        this.preLoadNumber = 1;
    }

    @NotNull
    public final LoadMoreStatus getLoadMoreStatus() {
        return this.loadMoreStatus;
    }

    public final boolean isLoadEndMoreGone() {
        return this.isLoadEndMoreGone;
    }

    @NotNull
    public final BaseLoadMoreView getLoadMoreView() {
        return this.loadMoreView;
    }

    public final void setLoadMoreView(@NotNull BaseLoadMoreView baseLoadMoreView) {
        Intrinsics.checkNotNullParameter((Object)baseLoadMoreView, (String)"<set-?>");
        this.loadMoreView = baseLoadMoreView;
    }

    public final boolean getEnableLoadMoreEndClick() {
        return this.enableLoadMoreEndClick;
    }

    public final void setEnableLoadMoreEndClick(boolean bl) {
        this.enableLoadMoreEndClick = bl;
    }

    public final boolean isAutoLoadMore() {
        return this.isAutoLoadMore;
    }

    public final void setAutoLoadMore(boolean bl) {
        this.isAutoLoadMore = bl;
    }

    public final boolean isEnableLoadMoreIfNotFullPage() {
        return this.isEnableLoadMoreIfNotFullPage;
    }

    public final void setEnableLoadMoreIfNotFullPage(boolean bl) {
        this.isEnableLoadMoreIfNotFullPage = bl;
    }

    public final int getPreLoadNumber() {
        return this.preLoadNumber;
    }

    public final void setPreLoadNumber(int value) {
        if (value > 1) {
            this.preLoadNumber = value;
        }
    }

    public final boolean isLoading() {
        return this.loadMoreStatus == LoadMoreStatus.Loading;
    }

    public final int getLoadMoreViewPosition() {
        if (this.baseQuickAdapter.hasEmptyView()) {
            return -1;
        }
        BaseQuickAdapter<?, ?> it = this.baseQuickAdapter;
        boolean bl = false;
        return it.getHeaderLayoutCount() + it.getData().size() + it.getFooterLayoutCount();
    }

    public final boolean isEnableLoadMore() {
        return this.isEnableLoadMore;
    }

    public final void setEnableLoadMore(boolean value) {
        boolean oldHasLoadMore = this.hasLoadMoreView();
        this.isEnableLoadMore = value;
        boolean newHasLoadMore = this.hasLoadMoreView();
        if (oldHasLoadMore) {
            if (!newHasLoadMore) {
                this.baseQuickAdapter.notifyItemRemoved(this.getLoadMoreViewPosition());
            }
        } else if (newHasLoadMore) {
            this.loadMoreStatus = LoadMoreStatus.Complete;
            this.baseQuickAdapter.notifyItemInserted(this.getLoadMoreViewPosition());
        }
    }

    public final void setupViewHolder$com_github_CymChad_brvah(@NotNull BaseViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        viewHolder.itemView.setOnClickListener(arg_0 -> BaseLoadMoreModule.setupViewHolder$lambda$1(this, arg_0));
    }

    public final void loadMoreToLoading() {
        if (this.loadMoreStatus == LoadMoreStatus.Loading) {
            return;
        }
        this.loadMoreStatus = LoadMoreStatus.Loading;
        this.baseQuickAdapter.notifyItemChanged(this.getLoadMoreViewPosition());
        this.invokeLoadMoreListener();
    }

    public final boolean hasLoadMoreView() {
        if (this.mLoadMoreListener == null || !this.isEnableLoadMore) {
            return false;
        }
        if (this.loadMoreStatus == LoadMoreStatus.End && this.isLoadEndMoreGone) {
            return false;
        }
        return !((Collection)this.baseQuickAdapter.getData()).isEmpty();
    }

    public final void autoLoadMore$com_github_CymChad_brvah(int position) {
        if (!this.isAutoLoadMore) {
            return;
        }
        if (!this.hasLoadMoreView()) {
            return;
        }
        if (position < this.baseQuickAdapter.getItemCount() - this.preLoadNumber) {
            return;
        }
        if (this.loadMoreStatus != LoadMoreStatus.Complete) {
            return;
        }
        if (this.loadMoreStatus == LoadMoreStatus.Loading) {
            return;
        }
        if (!this.mNextLoadEnable) {
            return;
        }
        this.invokeLoadMoreListener();
    }

    private final void invokeLoadMoreListener() {
        block1: {
            block0: {
                this.loadMoreStatus = LoadMoreStatus.Loading;
                RecyclerView recyclerView = this.baseQuickAdapter.getRecyclerViewOrNull();
                if (recyclerView == null) break block0;
                RecyclerView it = recyclerView;
                boolean bl = false;
                it.post(() -> BaseLoadMoreModule.invokeLoadMoreListener$lambda$3$lambda$2(this));
                break block1;
            }
            OnLoadMoreListener onLoadMoreListener = this.mLoadMoreListener;
            if (onLoadMoreListener == null) break block1;
            onLoadMoreListener.onLoadMore();
        }
    }

    public final void checkDisableLoadMoreIfNotFullPage() {
        if (this.isEnableLoadMoreIfNotFullPage) {
            return;
        }
        this.mNextLoadEnable = false;
        RecyclerView recyclerView = this.baseQuickAdapter.getRecyclerViewOrNull();
        if (recyclerView == null) {
            return;
        }
        RecyclerView recyclerView2 = recyclerView;
        RecyclerView.LayoutManager layoutManager = recyclerView2.getLayoutManager();
        if (layoutManager == null) {
            return;
        }
        RecyclerView.LayoutManager manager = layoutManager;
        if (manager instanceof LinearLayoutManager) {
            recyclerView2.postDelayed(() -> BaseLoadMoreModule.checkDisableLoadMoreIfNotFullPage$lambda$4(this, manager), 50L);
        } else if (manager instanceof StaggeredGridLayoutManager) {
            recyclerView2.postDelayed(() -> BaseLoadMoreModule.checkDisableLoadMoreIfNotFullPage$lambda$5(manager, this), 50L);
        }
    }

    private final boolean isFullScreen(LinearLayoutManager llm) {
        return llm.findLastCompletelyVisibleItemPosition() + 1 != this.baseQuickAdapter.getItemCount() || llm.findFirstCompletelyVisibleItemPosition() != 0;
    }

    private final int getTheBiggestNumber(int[] numbers) {
        int tmp = -1;
        if (numbers == null || numbers.length == 0) {
            return tmp;
        }
        for (int num : numbers) {
            if (num <= tmp) continue;
            tmp = num;
        }
        return tmp;
    }

    @JvmOverloads
    public final void loadMoreEnd(boolean gone) {
        if (!this.hasLoadMoreView()) {
            return;
        }
        this.isLoadEndMoreGone = gone;
        this.loadMoreStatus = LoadMoreStatus.End;
        if (gone) {
            this.baseQuickAdapter.notifyItemRemoved(this.getLoadMoreViewPosition());
        } else {
            this.baseQuickAdapter.notifyItemChanged(this.getLoadMoreViewPosition());
        }
    }

    public static /* synthetic */ void loadMoreEnd$default(BaseLoadMoreModule baseLoadMoreModule, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadMoreEnd");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        baseLoadMoreModule.loadMoreEnd(bl);
    }

    public final void loadMoreComplete() {
        if (!this.hasLoadMoreView()) {
            return;
        }
        this.loadMoreStatus = LoadMoreStatus.Complete;
        this.baseQuickAdapter.notifyItemChanged(this.getLoadMoreViewPosition());
        this.checkDisableLoadMoreIfNotFullPage();
    }

    public final void loadMoreFail() {
        if (!this.hasLoadMoreView()) {
            return;
        }
        this.loadMoreStatus = LoadMoreStatus.Fail;
        this.baseQuickAdapter.notifyItemChanged(this.getLoadMoreViewPosition());
    }

    @Override
    public void setOnLoadMoreListener(@Nullable OnLoadMoreListener listener) {
        this.mLoadMoreListener = listener;
        this.setEnableLoadMore(true);
    }

    public final void reset$com_github_CymChad_brvah() {
        if (this.mLoadMoreListener != null) {
            this.setEnableLoadMore(true);
            this.loadMoreStatus = LoadMoreStatus.Complete;
        }
    }

    @JvmOverloads
    public final void loadMoreEnd() {
        BaseLoadMoreModule.loadMoreEnd$default(this, false, 1, null);
    }

    private static final void setupViewHolder$lambda$1(BaseLoadMoreModule this$0, View it) {
        if (this$0.loadMoreStatus == LoadMoreStatus.Fail) {
            this$0.loadMoreToLoading();
        } else if (this$0.loadMoreStatus == LoadMoreStatus.Complete) {
            this$0.loadMoreToLoading();
        } else if (this$0.enableLoadMoreEndClick && this$0.loadMoreStatus == LoadMoreStatus.End) {
            this$0.loadMoreToLoading();
        }
    }

    private static final void invokeLoadMoreListener$lambda$3$lambda$2(BaseLoadMoreModule this$0) {
        block0: {
            OnLoadMoreListener onLoadMoreListener = this$0.mLoadMoreListener;
            if (onLoadMoreListener == null) break block0;
            onLoadMoreListener.onLoadMore();
        }
    }

    private static final void checkDisableLoadMoreIfNotFullPage$lambda$4(BaseLoadMoreModule this$0, RecyclerView.LayoutManager $manager) {
        if (this$0.isFullScreen((LinearLayoutManager)$manager)) {
            this$0.mNextLoadEnable = true;
        }
    }

    private static final void checkDisableLoadMoreIfNotFullPage$lambda$5(RecyclerView.LayoutManager $manager, BaseLoadMoreModule this$0) {
        int[] positions = new int[((StaggeredGridLayoutManager)$manager).getSpanCount()];
        ((StaggeredGridLayoutManager)$manager).findLastCompletelyVisibleItemPositions(positions);
        int pos = this$0.getTheBiggestNumber(positions) + 1;
        if (pos != this$0.baseQuickAdapter.getItemCount()) {
            this$0.mNextLoadEnable = true;
        }
    }
}

