/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import android.graphics.Bitmap;
import android.graphics.Rect;
import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.ArgbBuffer;
import io.github.crow_misia.libyuv.BitmapConverter;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.BufferFactory;
import io.github.crow_misia.libyuv.BufferKt;
import io.github.crow_misia.libyuv.Capacity;
import io.github.crow_misia.libyuv.CapacityCalculator;
import io.github.crow_misia.libyuv.I420Buffer;
import io.github.crow_misia.libyuv.Plane;
import io.github.crow_misia.libyuv.Plane1Capacities;
import io.github.crow_misia.libyuv.PlanePrimitive;
import io.github.crow_misia.libyuv.RowStride;
import io.github.crow_misia.libyuv.Yuv;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B;\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001aJ2\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006$"}, d2={"Lio/github/crow_misia/libyuv/Rgb565Buffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "Lio/github/crow_misia/libyuv/BitmapConverter;", "buffer", "Ljava/nio/ByteBuffer;", "plane", "Lio/github/crow_misia/libyuv/Plane;", "width", "", "height", "cropRect", "Landroid/graphics/Rect;", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;Lio/github/crow_misia/libyuv/Plane;IILandroid/graphics/Rect;Ljava/lang/Runnable;)V", "getHeight", "()I", "getPlane", "()Lio/github/crow_misia/libyuv/Plane;", "getWidth", "asBitmap", "Landroid/graphics/Bitmap;", "convertTo", "", "dst", "Lio/github/crow_misia/libyuv/ArgbBuffer;", "Lio/github/crow_misia/libyuv/I420Buffer;", "getPlaneOffset", "planeIndex", "rowStride", "Lio/github/crow_misia/libyuv/RowStride;", "left", "top", "getPlaneOffset-fuXAFhI", "(IIII)I", "Factory", "core_release"})
public final class Rgb565Buffer
extends AbstractBuffer
implements BitmapConverter {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final Plane plane;
    private final int width;
    private final int height;

    private Rgb565Buffer(ByteBuffer buffer, Plane plane, int width, int height, Rect cropRect, Runnable releaseCallback) {
        Plane[] planeArray = new Plane[]{plane};
        super(buffer, cropRect, planeArray, releaseCallback);
        this.plane = plane;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public final Plane getPlane() {
        return this.plane;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getPlaneOffset-fuXAFhI(int planeIndex, int rowStride, int left, int top) {
        return RowStride.times-impl(rowStride, top) + (left << 1);
    }

    @Override
    @NotNull
    public Bitmap asBitmap() {
        return BufferExtKt.toBitmap(this.asBuffer(), this.getWidth(), this.getHeight(), Bitmap.Config.RGB_565);
    }

    public final void convertTo(@NotNull I420Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Pair<Integer, Integer> pair = BufferKt.calculateSize(this, dst);
        int fixedWidth = ((Number)pair.component1()).intValue();
        int fixedHeight = ((Number)pair.component2()).intValue();
        Yuv.INSTANCE.convertRGB565ToI420(this.plane.getBuffer(), this.plane.getRowStride-BElzS_M(), BufferKt.offset(this, 0), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride-BElzS_M(), BufferKt.offset(dst, 0), dst.getPlaneU().getBuffer(), dst.getPlaneU().getRowStride-BElzS_M(), BufferKt.offset(dst, 1), dst.getPlaneV().getBuffer(), dst.getPlaneV().getRowStride-BElzS_M(), BufferKt.offset(dst, 2), fixedWidth, fixedHeight);
    }

    public final void convertTo(@NotNull ArgbBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Pair<Integer, Integer> pair = BufferKt.calculateSize(this, dst);
        int fixedWidth = ((Number)pair.component1()).intValue();
        int fixedHeight = ((Number)pair.component2()).intValue();
        Yuv.INSTANCE.convertRGB565ToARGB(this.plane.getBuffer(), this.plane.getRowStride-BElzS_M(), BufferKt.offset(this, 0), dst.getPlane().getBuffer(), dst.getPlane().getRowStride-BElzS_M(), BufferKt.offset(dst, 0), fixedWidth, fixedHeight);
    }

    public /* synthetic */ Rgb565Buffer(ByteBuffer buffer, Plane plane, int width, int height, Rect cropRect, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, plane, width, height, cropRect, releaseCallback);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u001e\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ&\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0012"}, d2={"Lio/github/crow_misia/libyuv/Rgb565Buffer$Factory;", "Lio/github/crow_misia/libyuv/BufferFactory;", "Lio/github/crow_misia/libyuv/Rgb565Buffer;", "Lio/github/crow_misia/libyuv/CapacityCalculator;", "Lio/github/crow_misia/libyuv/Plane1Capacities;", "()V", "allocate", "width", "", "height", "cropRect", "Landroid/graphics/Rect;", "calculate", "wrap", "plane", "Lio/github/crow_misia/libyuv/Plane;", "buffer", "Ljava/nio/ByteBuffer;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nRgb565Buffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rgb565Buffer.kt\nio/github/crow_misia/libyuv/Rgb565Buffer$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
    public static final class Factory
    implements BufferFactory<Rgb565Buffer>,
    CapacityCalculator<Plane1Capacities> {
        private Factory() {
        }

        @Override
        @NotNull
        public Plane1Capacities calculate(int width, int height) {
            int stride = width << 1;
            int n = RowStride.constructor-impl(stride);
            int n2 = Capacity.constructor-impl(stride * height);
            return new Plane1Capacities(n2, n, null);
        }

        @Override
        @NotNull
        public Rgb565Buffer allocate(int width, int height, @NotNull Rect cropRect) {
            Intrinsics.checkNotNullParameter((Object)cropRect, (String)"cropRect");
            Plane1Capacities plane1Capacities = this.calculate(width, height);
            int capacity = plane1Capacities.component1-v5S6rBc();
            int stride = plane1Capacities.component2-BElzS_M();
            ByteBuffer buffer = BufferExtKt.createByteBuffer(CollectionsKt.listOf((Object)Capacity.box-impl(capacity)))[0];
            return new Rgb565Buffer(buffer, new PlanePrimitive(stride, buffer, null), width, height, cropRect, () -> Factory.allocate$lambda$0(buffer), null);
        }

        @Override
        @NotNull
        public Rgb565Buffer wrap(@NotNull ByteBuffer buffer, int width, int height, @NotNull Rect cropRect) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)cropRect, (String)"cropRect");
            if (!buffer.isDirect()) {
                boolean $i$a$-check-Rgb565Buffer$Factory$wrap$22 = false;
                String $i$a$-check-Rgb565Buffer$Factory$wrap$22 = "Unsupported non-direct ByteBuffer.";
                throw new IllegalStateException($i$a$-check-Rgb565Buffer$Factory$wrap$22.toString());
            }
            Plane1Capacities plane1Capacities = this.calculate(width, height);
            int capacity = plane1Capacities.component1-v5S6rBc();
            int stride = plane1Capacities.component2-BElzS_M();
            ByteBuffer sliceBuffer = BufferExtKt.sliceRange(buffer, 0, capacity);
            return new Rgb565Buffer(sliceBuffer, new PlanePrimitive(stride, sliceBuffer, null), width, height, cropRect, null, null);
        }

        @NotNull
        public final Rgb565Buffer wrap(@NotNull Plane plane, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
            return this.wrap(plane, width, height, new Rect(0, 0, width, height));
        }

        @NotNull
        public final Rgb565Buffer wrap(@NotNull Plane plane, int width, int height, @NotNull Rect cropRect) {
            Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
            Intrinsics.checkNotNullParameter((Object)cropRect, (String)"cropRect");
            return new Rgb565Buffer(plane.getBuffer(), plane, width, height, cropRect, null, null);
        }

        @Override
        @NotNull
        public Rgb565Buffer allocate(int width, int height) {
            return BufferFactory.DefaultImpls.allocate(this, width, height);
        }

        @Override
        @NotNull
        public Rgb565Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            return BufferFactory.DefaultImpls.wrap(this, buffer, width, height);
        }

        private static final void allocate$lambda$0(ByteBuffer $buffer) {
            Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
            Yuv.INSTANCE.freeNativeBuffer($buffer);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

