/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import android.graphics.Rect;
import io.github.crow_misia.libyuv.Buffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a)\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\u0006\u001a)\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\u0006\u001a \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a%\u0010\u0000\u001a\u00020\u0001*\u00020\u000b2\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\r\u001a%\u0010\u0007\u001a\u00020\u0001*\u00020\u000b2\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u00a8\u0006\u0010"}, d2={"minHeight", "", "height", "other", "", "Landroid/graphics/Rect;", "(I[Landroid/graphics/Rect;)I", "minWidth", "width", "calculateSize", "Lkotlin/Pair;", "Lio/github/crow_misia/libyuv/Buffer;", "dst", "(Lio/github/crow_misia/libyuv/Buffer;[Landroid/graphics/Rect;)I", "offset", "planeIndex", "core_release"})
public final class BufferKt {
    public static final int minWidth(int width, Rect ... other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int min = width;
        for (Rect e : other) {
            min = Math.min(min, e.width());
        }
        return min;
    }

    public static final int minHeight(int height, Rect ... other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int min = height;
        for (Rect e : other) {
            min = Math.min(min, e.height());
        }
        return min;
    }

    @NotNull
    public static final Pair<Integer, Integer> calculateSize(@NotNull Buffer $this$calculateSize, @NotNull Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateSize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Rect[] rectArray = new Rect[]{$this$calculateSize.getCropRect(), dst.getCropRect()};
        Integer n = BufferKt.minWidth($this$calculateSize, rectArray);
        rectArray = new Rect[]{$this$calculateSize.getCropRect(), dst.getCropRect()};
        return new Pair((Object)n, (Object)BufferKt.minHeight($this$calculateSize, rectArray));
    }

    public static final int minWidth(@NotNull Buffer $this$minWidth, Rect ... other) {
        Intrinsics.checkNotNullParameter((Object)$this$minWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return BufferKt.minWidth($this$minWidth.getCropRect().width(), Arrays.copyOf(other, other.length));
    }

    public static final int minHeight(@NotNull Buffer $this$minHeight, Rect ... other) {
        Intrinsics.checkNotNullParameter((Object)$this$minHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return BufferKt.minHeight($this$minHeight.getCropRect().height(), Arrays.copyOf(other, other.length));
    }

    public static final int offset(@NotNull Buffer $this$offset, int planeIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$offset, (String)"<this>");
        return $this$offset.getPlanes()[planeIndex].offset$core_release($this$offset, planeIndex);
    }
}

