/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import android.graphics.Bitmap;
import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.ArgbBuffer;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.ConvertKt;
import io.github.crow_misia.libyuv.Yuv;
import java.io.Closeable;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lio/github/crow_misia/libyuv/Rgb24Buffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "strideRGB24", "", "width", "height", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;IIILjava/lang/Runnable;)V", "getBuffer$libyuv_android", "()Ljava/nio/ByteBuffer;", "getHeight", "()I", "getStrideRGB24$libyuv_android", "getWidth", "asBitmap", "Landroid/graphics/Bitmap;", "asBuffer", "asByteArray", "", "", "dst", "Companion", "libyuv-android"})
public final class Rgb24Buffer
extends AbstractBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer buffer;
    private final int strideRGB24;
    private final int width;
    private final int height;

    private Rgb24Buffer(ByteBuffer buffer, int strideRGB24, int width, int height, Runnable releaseCallback) {
        super(releaseCallback);
        this.buffer = buffer;
        this.strideRGB24 = strideRGB24;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public final ByteBuffer getBuffer$libyuv_android() {
        return this.buffer;
    }

    public final int getStrideRGB24$libyuv_android() {
        return this.strideRGB24;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public ByteBuffer asBuffer() {
        return this.buffer;
    }

    @Override
    @NotNull
    public byte[] asByteArray() {
        return BufferExtKt.asByteArray(this.buffer);
    }

    @Override
    public void asByteArray(@NotNull byte[] dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        BufferExtKt.asByteArray(this.buffer, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bitmap asBitmap() {
        Bitmap bitmap;
        Closeable closeable = ArgbBuffer.Companion.allocate(this.getWidth(), this.getHeight());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ArgbBuffer it = (ArgbBuffer)closeable;
            boolean bl3 = false;
            ConvertKt.convert(this, it);
            bitmap = it.asBitmap();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bitmap;
    }

    @JvmStatic
    @NotNull
    public static final int[] getStrideWithCapacity(int width, int height) {
        return Companion.getStrideWithCapacity(width, height);
    }

    @JvmStatic
    @NotNull
    public static final Rgb24Buffer allocate(int width, int height) {
        return Companion.allocate(width, height);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rgb24Buffer wrap(@NotNull ByteBuffer buffer, int width, int height, @Nullable Runnable releaseCallback) {
        return Companion.wrap(buffer, width, height, releaseCallback);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rgb24Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
        return Companion.wrap(buffer, width, height);
    }

    public /* synthetic */ Rgb24Buffer(ByteBuffer buffer, int strideRGB24, int width, int height, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, strideRGB24, width, height, releaseCallback);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J,\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lio/github/crow_misia/libyuv/Rgb24Buffer$Companion;", "", "()V", "allocate", "Lio/github/crow_misia/libyuv/Rgb24Buffer;", "width", "", "height", "getStrideWithCapacity", "", "wrap", "buffer", "Ljava/nio/ByteBuffer;", "releaseCallback", "Ljava/lang/Runnable;", "libyuv-android"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final int[] getStrideWithCapacity(int width, int height) {
            int stride = width * 3;
            int capacity = stride * height;
            int[] nArray = new int[]{stride, capacity};
            return nArray;
        }

        @JvmStatic
        @NotNull
        public final Rgb24Buffer allocate(int width, int height) {
            int[] nArray;
            int[] nArray2 = nArray = this.getStrideWithCapacity(width, height);
            boolean bl = false;
            int stride = nArray2[0];
            int[] nArray3 = nArray;
            boolean bl2 = false;
            int capacity = nArray3[1];
            ByteBuffer buffer = BufferExtKt.createByteBuffer(capacity);
            return new Rgb24Buffer(buffer, stride, width, height, () -> Companion.allocate$lambda-0(buffer), null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rgb24Buffer wrap(@NotNull ByteBuffer buffer, int width, int height, @Nullable Runnable releaseCallback) {
            int[] nArray;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int[] nArray2 = nArray = this.getStrideWithCapacity(width, height);
            boolean bl = false;
            int stride = nArray2[0];
            int[] nArray3 = nArray;
            boolean bl2 = false;
            int capacity = nArray3[1];
            return new Rgb24Buffer(BufferExtKt.sliceRange(buffer, 0, capacity), stride, width, height, releaseCallback, null);
        }

        public static /* synthetic */ Rgb24Buffer wrap$default(Companion companion, ByteBuffer byteBuffer, int n, int n2, Runnable runnable, int n3, Object object) {
            if ((n3 & 8) != 0) {
                runnable = null;
            }
            return companion.wrap(byteBuffer, n, n2, runnable);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rgb24Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return io.github.crow_misia.libyuv.Rgb24Buffer$Companion.wrap$default(this, buffer, width, height, null, 8, null);
        }

        private static final void allocate$lambda-0(ByteBuffer $buffer) {
            Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
            Yuv.INSTANCE.freeNativeBuffer($buffer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

