/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.logging;

import com.amazonaws.services.lambda.runtime.api.client.logging.FrameType;
import com.amazonaws.services.lambda.runtime.api.client.logging.LogSink;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FramedTelemetryLogSink
implements LogSink {
    private static final int HEADER_LENGTH = 8;
    private final FileOutputStream logOutputStream;
    private final ByteBuffer headerBuf;

    public FramedTelemetryLogSink(File file) throws IOException {
        this.logOutputStream = new FileOutputStream(file);
        this.headerBuf = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public synchronized void log(byte[] message) {
        try {
            this.writeFrame(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeFrame(byte[] message) throws IOException {
        this.updateHeader(message.length);
        this.logOutputStream.write(this.headerBuf.array());
        this.logOutputStream.write(message);
    }

    private void updateHeader(int length) {
        this.headerBuf.clear();
        this.headerBuf.putInt(FrameType.LOG.getValue());
        this.headerBuf.putInt(length);
        this.headerBuf.flip();
    }

    @Override
    public void close() throws IOException {
        this.logOutputStream.close();
    }
}

