/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.dart.system.io;

import com.github.cleydyr.dart.system.io.FilesystemExecutableResourcesProvider;
import com.github.cleydyr.dart.system.io.ReleaseDownloader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class TarFilesystemExecutableResourcesProvider
extends FilesystemExecutableResourcesProvider {
    public TarFilesystemExecutableResourcesProvider(File repository, ReleaseDownloader downloader) {
        super(repository, downloader);
    }

    @Override
    protected InputStream getResourceFromReleaseArchive(String resourceName, File release) throws IOException {
        TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(release.toPath(), new OpenOption[0]))));
        TarArchiveEntry entry = tarArchiveInputStream.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals(resourceName)) {
                return tarArchiveInputStream;
            }
            entry = tarArchiveInputStream.getNextEntry();
        }
        throw new IOException("Can't find resource " + resourceName + " inside release archive at " + release.getAbsolutePath());
    }
}

