/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.dart.net;

import com.github.cleydyr.dart.net.DummyGithubLatestVersionProvider;
import com.github.cleydyr.dart.net.GithubLatestVersionProvider;
import com.github.cleydyr.dart.release.DartSassReleaseParameter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.logging.Logger;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubAbuseLimitHandler;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.GitHubRateLimitHandler;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.connector.GitHubConnectorResponse;
import org.kohsuke.github.extras.ImpatientHttpConnector;
import org.kohsuke.github.internal.GitHubConnectorHttpConnectorAdapter;

@Singleton
@Named
public class NetworkingGithubLatestVersionProvider
implements GithubLatestVersionProvider {
    @Inject
    private Logger logger;
    @Inject
    private MavenSession mavenSession;
    private final GithubLatestVersionProvider fallbackVersionProvider = new DummyGithubLatestVersionProvider();

    @Override
    public String get(String os, String arch) {
        block7: {
            try {
                GitHub github = new GitHubBuilder().withConnector(GitHubConnectorHttpConnectorAdapter.adapt((HttpConnector)new ImpatientHttpConnector(this::setupConnection))).withRateLimitHandler(new GitHubRateLimitHandler(){

                    public void onError(GitHubConnectorResponse ghcr) throws IOException {
                        throw new IOException("GitHub rate limit exceeded.");
                    }
                }).withAbuseLimitHandler(new GitHubAbuseLimitHandler(){

                    public void onError(GitHubConnectorResponse ghcr) throws IOException {
                        throw new IOException("GitHub abuse limit hit.");
                    }
                }).build();
                GHRepository repository = github.getRepository("sass/dart-sass");
                PagedIterable ghReleases = repository.listReleases();
                for (GHRelease ghRelease : ghReleases) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Checking release " + ghRelease.getName());
                    }
                    String version = ghRelease.getTagName();
                    DartSassReleaseParameter dartSassReleaseParameter = new DartSassReleaseParameter(os, arch, version);
                    for (GHAsset ghAsset : ghRelease.listAssets()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Checking asset " + ghAsset.getName());
                        }
                        if (!ghAsset.getName().equals(dartSassReleaseParameter.getArtifactName())) continue;
                        return version;
                    }
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("Skipping version " + version + " because it doesn't have a matching asset");
                }
            }
            catch (IOException e) {
                if (!this.logger.isWarnEnabled()) break block7;
                this.logger.warn("Error while getting latest version from GitHub API", (Throwable)e);
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Falling back to latest known release (" + this.fallbackVersionProvider.get(os, arch) + ")");
        }
        return this.fallbackVersionProvider.get(os, arch);
    }

    public HttpURLConnection setupConnection(URL url) throws IOException {
        if (this.mavenSession == null || this.mavenSession.getSettings() == null || this.mavenSession.getSettings().getActiveProxy() == null) {
            return (HttpURLConnection)url.openConnection();
        }
        return this.setupWithMavenSettings(url);
    }

    public HttpURLConnection setupWithMavenSettings(URL url) throws IOException {
        try {
            Settings settings = this.mavenSession.getSettings();
            Proxy activeProxy = settings.getActiveProxy();
            if (activeProxy == null) {
                return (HttpURLConnection)url.openConnection();
            }
            java.net.Proxy proxy = NetworkingGithubLatestVersionProvider.getProxy(activeProxy);
            return (HttpURLConnection)url.openConnection(proxy);
        }
        catch (IOException e) {
            this.logger.warn("Error while parsing maven settings. Settings like proxy will be ignored.");
            return (HttpURLConnection)url.openConnection();
        }
    }

    private static java.net.Proxy getProxy(Proxy activeProxy) {
        String hostname = activeProxy.getHost();
        int port = activeProxy.getPort();
        return new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
    }
}

